/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.oppo;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.oppoOcpx.OppoOcpxRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OppoAppConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(OppoAppConversionFeedback.class);
    private final OppoOcpxRtbIntegration integration;

    public OppoAppConversionFeedback(OppoOcpxRtbIntegration integration) {
        this.integration = integration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        byte[] base64;
        JSONObject extParamsJsonObject = new JSONObject();
        String extParams = (String)feedbackLog.getFirst((Object)"ext_params");
        if (StringUtils.isNotBlank((String)extParams) && Objects.isNull(extParamsJsonObject = JSONObject.parseObject((String)StringHelper.convert((byte[])(base64 = Base64.decodeBase64((String)extParams)))))) {
            log.warn("[OPPOOCPX] extParams is null!");
        }
        feedbackLog.add((Object)"imei_md5", (Object)extParamsJsonObject.getString("imei_md5"));
        feedbackLog.add((Object)"oaid", (Object)extParamsJsonObject.getString("oaid"));
        feedbackLog.add((Object)"ad_id", (Object)extParamsJsonObject.getString("ad_id"));
        feedbackLog.add((Object)"package", (Object)extParamsJsonObject.getString("package"));
        feedbackLog.add((Object)"customType", (Object)extParamsJsonObject.getString("customType"));
        try {
            this.integration.doFeedback(FeedbackRequest.builder().keyValueMap(feedbackLog).eventType(targetType).clickId(clickId).build(), 2);
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        HashMap<String, String> ext = new HashMap<String, String>();
        ext.put("imei_md5", this.defaultValue((String)clickLog.getFirst((Object)"imei_md5"), "__IMEI__"));
        ext.put("oaid", this.defaultValue((String)clickLog.getFirst((Object)"oaid"), "__OAID__"));
        ext.put("ad_id", this.defaultValue((String)clickLog.getFirst((Object)"ad_id"), "__ADID__"));
        ext.put("package", this.defaultValue((String)clickLog.getFirst((Object)"package"), "__PKG__"));
        ext.put("customType", this.defaultValue((String)clickLog.getFirst((Object)"customType"), "__CUSTOM__"));
        return Base64.encodeBase64URLSafeString((byte[])JsonHelper.convert2bytes(ext));
    }

    private String defaultValue(String data, String placeholder) {
        return Optional.ofNullable(data).filter(s -> !placeholder.equals(s)).orElse("");
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.OPPO_APP;
    }
}

