/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.pangu;

import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class PanguConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(PanguConversionFeedback.class);
    private static final String CONVERSION_TYPE = "conversion_type";
    private static final String CALLBACK = "callback";
    private final HttpClient httpClient = PanguConversionFeedback.createHttpClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        String callBack = (String)feedbackLog.getFirst((Object)CALLBACK);
        if (StringUtils.isBlank((String)callBack)) {
            log.error("callback is blank, feedbackLog: {}", (Object)feedbackLog);
            return;
        }
        callBack = UrlHelper.urlDecode((String)callBack);
        String url = UriComponentsBuilder.fromUriString((String)callBack).replaceQueryParam(CONVERSION_TYPE, new Object[]{targetType}).build().toString();
        HttpGet get = new HttpGet(url);
        try {
            this.httpClient.execute((HttpUriRequest)get);
            log.info("pangu ocpx conversion success, url: {} ", (Object)url);
        }
        catch (IOException e) {
            log.error("execute: ", (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.PANGU;
    }

    private static CloseableHttpClient createHttpClient() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectionRequestTimeout(1000).setConnectTimeout(1000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
    }
}

