/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.qutoutiao;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.utils.HttpClientUtils;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class QuTouTiaoConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(QuTouTiaoConversionFeedback.class);
    private final HttpClient httpClient = HttpClientUtils.createHttpClient(50, 100, 1000, 500, 1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        if (StringUtils.isEmpty((String)clickId)) {
            return;
        }
        String feedbackUrl = UrlHelper.urlDecode((String)clickId);
        String url = UriComponentsBuilder.fromUriString((String)feedbackUrl).replaceQueryParam("op2", new Object[]{targetType}).replaceQueryParam("opt_active_time", new Object[]{System.currentTimeMillis()}).build().toString();
        HttpGet get = new HttpGet(url);
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String entity = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            log.info("qutoutiao feedback success url:{} response:{}", (Object)url, (Object)JSONObject.parseObject((String)entity));
        }
        catch (IOException e) {
            log.warn("qutoutiao feedback error url:{} feedbackLog:{} clickId:{} targetType:{} exception:{}", new Object[]{url, feedbackLog, clickId, targetType, e.getMessage()});
        }
        finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.QUTOUTIAO;
    }
}

