/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.weibo;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.weibo.WeiBoAppRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WeiBoAppConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(WeiBoAppConversionFeedback.class);
    private final WeiBoAppRtbIntegration integration;

    public WeiBoAppConversionFeedback(WeiBoAppRtbIntegration integration) {
        this.integration = integration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        String extParams = (String)feedbackLog.getFirst((Object)"ext_params");
        if (StringUtils.isBlank((String)extParams)) {
            log.error("[WeiBoApp] extParams is null!");
            return;
        }
        byte[] base64 = Base64.decodeBase64((String)extParams);
        JSONObject jsonObject = JSONObject.parseObject((String)StringHelper.convert((byte[])base64));
        feedbackLog.add((Object)"imei_md5", (Object)jsonObject.getString("imei_md5"));
        feedbackLog.add((Object)"oaid_md5", (Object)jsonObject.getString("oaid_md5"));
        feedbackLog.add((Object)"idfa_md5", (Object)jsonObject.getString("idfa_md5"));
        feedbackLog.add((Object)"company", (Object)jsonObject.getString("company"));
        try {
            this.integration.doFeedback(FeedbackRequest.builder().keyValueMap(feedbackLog).eventType(targetType).clickId(clickId).build(), 2);
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        HashMap<String, Object> ext = new HashMap<String, Object>(6);
        ext.put("imei_md5", clickLog.getFirst((Object)"imei_md5"));
        ext.put("oaid_md5", clickLog.getFirst((Object)"oaid_md5"));
        ext.put("idfa_md5", clickLog.getFirst((Object)"idfa_md5"));
        ext.put("company", clickLog.getFirst((Object)"company"));
        return Base64.encodeBase64URLSafeString((byte[])JsonHelper.convert2bytes(ext));
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.WEIBO_APP;
    }
}

