/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.wifi;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.wifiocpx.WifiOcpxRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WifiConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(WifiConversionFeedback.class);
    private final WifiOcpxRtbIntegration integration;

    public WifiConversionFeedback(WifiOcpxRtbIntegration integration) {
        this.integration = integration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        String extParams = (String)feedbackLog.getFirst((Object)"ext_params");
        if (StringUtils.isBlank((String)extParams)) {
            log.warn("wifi Cannot found extParams");
            return;
        }
        byte[] base64 = Base64.decodeBase64((String)extParams);
        JSONObject jsonObject = JSONObject.parseObject((String)StringHelper.convert((byte[])base64));
        feedbackLog.put("cid", jsonObject.getString("cid"));
        feedbackLog.put("sid", jsonObject.getString("sid"));
        feedbackLog.put("stime", jsonObject.getString("stime"));
        feedbackLog.put("os", jsonObject.getString("os"));
        feedbackLog.put("idfa", jsonObject.getString("idfa"));
        feedbackLog.put("mac", jsonObject.getString("mac"));
        feedbackLog.put("imei", jsonObject.getString("imei"));
        try {
            this.integration.doFeedback(FeedbackRequest.builder().keyValueMap(feedbackLog).eventType(targetType).clickId(clickId).build(), 2);
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.WIFI;
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        HashMap<String, Object> ext = new HashMap<String, Object>(10);
        ext.put("cid", clickLog.getFirst((Object)"cid"));
        ext.put("sid", clickLog.getFirst((Object)"sid"));
        ext.put("stime", clickLog.getFirst((Object)"stime"));
        ext.put("os", clickLog.getFirst((Object)"os"));
        ext.put("idfa", clickLog.getFirst((Object)"idfa"));
        ext.put("mac", clickLog.getFirst((Object)"mac"));
        ext.put("imei", clickLog.getFirst((Object)"imei"));
        return Base64.encodeBase64URLSafeString((byte[])JsonHelper.convert2bytes(ext));
    }
}

