/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.feedback.xiaomi;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.xiaomiocpx.XiaomiOcpxRtbIntegration;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class XiaomiConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(XiaomiConversionFeedback.class);
    private final XiaomiOcpxRtbIntegration xiaomiOcpxRtbIntegration;

    public XiaomiConversionFeedback(XiaomiOcpxRtbIntegration xiaomiOcpxRtbIntegration) {
        this.xiaomiOcpxRtbIntegration = xiaomiOcpxRtbIntegration;
    }

    @Override
    public void update(KeyValueMap clickLog) {
        String imei = (String)clickLog.getFirst((Object)"imei");
        String oaid = (String)clickLog.getFirst((Object)"oaid");
        clickLog.putIfNotBlank("x_imei", imei);
        clickLog.putIfNotBlank("x_oaid", oaid);
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        String oaid = (String)feedbackLog.getFirst((Object)"x_oaid");
        String imei = (String)feedbackLog.getFirst((Object)"x_imei");
        if (StringUtils.isBlank((String)oaid) && StringUtils.isBlank((String)imei)) {
            log.info("[xiaomiOcpx] Cannot found 'x_oaid' or 'x_imei'");
            String extParams = (String)feedbackLog.getFirst((Object)"ext_params");
            if (StringUtils.isBlank((String)extParams)) {
                log.info("[xiaomiOcpx] Cannot found 'extParams'");
                return;
            }
            byte[] base64 = Base64.decodeBase64((String)extParams);
            JSONObject extParamsJsonObject = JSONObject.parseObject((String)StringHelper.convert((byte[])base64));
            oaid = extParamsJsonObject.getString("oaid");
            imei = extParamsJsonObject.getString("imei");
        }
        if (StringUtils.isBlank((String)oaid) && StringUtils.isBlank((String)imei)) {
            log.info("[xiaomiOcpx] Cannot find 'oaid' or 'imei' from extParams");
            return;
        }
        feedbackLog.put("oaid", oaid);
        feedbackLog.put("imei", imei);
        FeedbackRequest request = FeedbackRequest.builder().keyValueMap(feedbackLog).clickId(clickId).eventType(targetType).build();
        try {
            this.xiaomiOcpxRtbIntegration.doFeedback(request);
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.XIAOMI;
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        HashMap ext = Maps.newHashMap();
        ext.put("oaid", clickLog.getFirst((Object)"oaid"));
        ext.put("imei", clickLog.getFirst((Object)"imei"));
        ext.put("test", "1");
        return Base64.encodeBase64URLSafeString((byte[])JsonHelper.convert2bytes((Object)ext));
    }
}

