/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.openlog.listener;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.model.overseas.OverseasClickCache;
import com.bxm.adscounter.ocpx.common.OcpxProperties;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedbackDispatcher;
import com.bxm.adscounter.ocpx.openlog.event.OverseasFeedbackEvent;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OverseasFeedbackEventListener
implements EventListener<OverseasFeedbackEvent> {
    private static final Logger log = LoggerFactory.getLogger(OverseasFeedbackEventListener.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(OverseasFeedbackEventListener.class);
    private final OcpxProperties properties;
    private final OpenLogClient openLogClient;
    private final JedisFetcher jedisFetcher;
    private final ConversionFeedbackDispatcher conversionFeedbackDispatcher;
    private static final String CLICK_ID = "bxmid";
    private static final String EVENT_NAME = "event_name";
    private static final String CONVERSION_TYPE = "conversion_type";

    public OverseasFeedbackEventListener(OcpxProperties properties, OpenLogClient openLogClient, JedisFetcher jedisFetcher, ConversionFeedbackDispatcher conversionFeedbackDispatcher) {
        this.properties = properties;
        this.openLogClient = openLogClient;
        this.jedisFetcher = jedisFetcher;
        this.conversionFeedbackDispatcher = conversionFeedbackDispatcher;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(OverseasFeedbackEvent event) {
        KeyValueMap feedback = event.getLog();
        String cashcatClickId = (String)feedback.getFirst((Object)CLICK_ID);
        OverseasClickCache overseasClickCache = (OverseasClickCache)this.jedisFetcher.fetch(RedisKeyGenerator.hashOverseasClickIdKey((String)cashcatClickId), OverseasClickCache.class);
        if (Objects.isNull(overseasClickCache)) {
            this.inadsConversionOpenLogForward(feedback);
            return;
        }
        this.logFill(feedback, overseasClickCache);
        this.conversionFeedbackDispatcher.dispatch(event);
        this.conversionDot(overseasClickCache, feedback, cashcatClickId);
    }

    void logFill(KeyValueMap feedback, OverseasClickCache overseasClickCache) {
        this.putConversionTypeIfNecessary(feedback, overseasClickCache.getOfferId());
        feedback.putIfNotBlank("bxmmedia", overseasClickCache.getMedia());
        feedback.putIfNotBlank("bxmadvertiser", RtbAdvertiser.Overseas.getType());
        feedback.putIfNotBlank("refer", overseasClickCache.getReferer());
        String sourceTargetMapping = overseasClickCache.getSourceTargetMapping();
        String convDef = StringUtils.isNotBlank((CharSequence)sourceTargetMapping) ? overseasClickCache.getSourceTargetMapping() : overseasClickCache.getSourceType() + "-" + overseasClickCache.getTargetType();
        feedback.putIfNotBlank("conv_def", convDef);
        feedback.putIfNotBlank("click_id", overseasClickCache.getClickId());
        feedback.putIfNotBlank("gaid", overseasClickCache.getGaid());
    }

    private void inadsConversionOpenLogForward(KeyValueMap log) {
        KeyValueMap keyValueMap = new KeyValueMap();
        KeyValueMap newLog = log.deepCopy(new String[]{"p", "mt"});
        newLog.setProduction(Production.INADS);
        newLog.setMt(Inads.Mt.AdConversion.original());
        String openLogRequestUri = newLog.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain(), keyValueMap, true);
        this.openLogClient.asyncRequest(openLogRequestUri);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("overseas forward to inads conversion mt. {}", (Object)openLogRequestUri);
        }
    }

    private void putConversionTypeIfNecessary(KeyValueMap feedback, String offerId) {
        JSONObject evenNameJSONObject;
        String eventName = (String)feedback.getFirst((Object)EVENT_NAME);
        if (StringUtils.isNotBlank((CharSequence)eventName) && null != (evenNameJSONObject = (JSONObject)this.jedisFetcher.hfetch(RedisKeyGenerator.hashEventNameMappingKey(), Objects.toString(offerId), JSONObject.class))) {
            feedback.putIfNotBlank(CONVERSION_TYPE, evenNameJSONObject.getString(eventName));
        }
    }

    private void conversionDot(OverseasClickCache clickCache, KeyValueMap feedback, String cashcatClickId) {
        KeyValueMap map = new KeyValueMap();
        map.put("p", Production.COMMON.getName());
        map.put("mt", Common.Mt.OverseasConversion.original());
        map.put("site_id", clickCache.getMediaChannel());
        map.put("site_name", clickCache.getMedia());
        map.put("campaign_id", clickCache.getCampaignId());
        map.put("campaign_name", clickCache.getCampaignName());
        map.put("offer_id", clickCache.getOfferId());
        map.put("click_id", clickCache.getClickId());
        map.put("conf_id", clickCache.getConfId());
        map.put("sub_id", clickCache.getSubId());
        map.put("gaid", clickCache.getGaid());
        map.put("time", (Object)System.currentTimeMillis());
        map.put(CONVERSION_TYPE, (String)feedback.getFirst((Object)RtbAdvertiser.Overseas.getTransferType()));
        map.put("ccid", cashcatClickId);
        map.put(EVENT_NAME, (String)feedback.getFirst((Object)EVENT_NAME));
        String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain());
        this.openLogClient.asyncRequest(openLogRequestUri);
        if (log.isDebugEnabled()) {
            log.debug("overseas conversion dot : {}", (Object)openLogRequestUri);
        }
    }
}

