/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report;

import com.bxm.adscounter.ocpx.exception.ReportFailException;
import com.bxm.adscounter.ocpx.report.ReportMicroMeter;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ReportMicroMeterAspect {
    private static final Logger log = LoggerFactory.getLogger(ReportMicroMeterAspect.class);
    private final ReportMicroMeter microMeter;

    public ReportMicroMeterAspect(ReportMicroMeter microMeter) {
        this.microMeter = microMeter;
    }

    @Pointcut(value="this(com.bxm.adscounter.ocpx.report.Reporter) && execution(* report(..))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public void around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof Reporter)) {
            point.proceed();
        }
        Object[] args = point.getArgs();
        KeyValueMap arg = (KeyValueMap)args[0];
        try {
            point.proceed();
        }
        catch (Exception e) {
            String bxmMedia_bxmAdvertiser = (String)arg.getFirst((Object)"bxmmedia") + "-" + (String)arg.getFirst((Object)"bxmadvertiser");
            if (e instanceof ReportFailException) {
                this.microMeter.incrementFail(bxmMedia_bxmAdvertiser);
                log.warn("{} reportFail :{}", (Object)bxmMedia_bxmAdvertiser, (Object)ExceptionUtils.getMessage((Throwable)e));
            }
            this.microMeter.incrementException(bxmMedia_bxmAdvertiser);
            log.error("{} reportException :{}", (Object)bxmMedia_bxmAdvertiser, (Object)ExceptionUtils.getMessage((Throwable)e));
        }
    }
}

