/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.ocpx.common.OcpxProperties;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedback;
import com.bxm.adscounter.ocpx.feedback.ConversionFeedbackFactory;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.adscounter.ocpx.report.ReporterFactory;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEvent;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ReporterDispatcher
implements MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(ReporterDispatcher.class);
    private final ConversionFeedbackFactory conversionFeedbackFactory;
    private final ReporterFactory reporterFactory;
    private final OcpxProperties properties;
    private MeterRegistry registry;

    public ReporterDispatcher(ConversionFeedbackFactory conversionFeedbackFactory, ReporterFactory reporterFactory, OcpxProperties properties) {
        this.conversionFeedbackFactory = conversionFeedbackFactory;
        this.reporterFactory = reporterFactory;
        this.properties = properties;
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    public void dispatch(OpenLogEvent event) {
        Reporter reporter;
        KeyValueMap clickTrackerLog = event.getLog();
        String bxmmedia = (String)clickTrackerLog.getFirst((Object)"bxmmedia");
        String bxmadvertiser = (String)clickTrackerLog.getFirst((Object)"bxmadvertiser");
        this.registry.counter("conv.report", new String[]{"map", bxmmedia + "-" + bxmadvertiser}).increment();
        if (StringUtils.isBlank((CharSequence)bxmmedia)) {
            log.warn("Missing param '{}'.", (Object)"bxmmedia");
            return;
        }
        if (StringUtils.isBlank((CharSequence)bxmadvertiser)) {
            log.warn("Missing param '{}'.", (Object)"bxmadvertiser");
            return;
        }
        RtbMedia rtbMedia = RtbMedia.getByType((String)bxmmedia);
        RtbAdvertiser rtbAdvertiser = RtbAdvertiser.getByType((String)bxmadvertiser);
        if (Objects.isNull(rtbMedia)) {
            log.warn("Illegal rtbMedia [{}]", (Object)bxmmedia);
            return;
        }
        if (Objects.isNull(rtbAdvertiser)) {
            log.warn("Illegal rtbAdvertiser [{}]", (Object)bxmadvertiser);
            return;
        }
        ConversionFeedback rtbInstance = (ConversionFeedback)this.conversionFeedbackFactory.get(rtbMedia);
        if (Objects.isNull(rtbInstance)) {
            return;
        }
        rtbInstance.update(clickTrackerLog);
        String extParams = rtbInstance.createExtParams(clickTrackerLog);
        if (StringUtils.isNotBlank((CharSequence)extParams)) {
            clickTrackerLog.put("ext_params", extParams);
        }
        if (Objects.isNull(reporter = (Reporter)this.reporterFactory.get(rtbAdvertiser))) {
            log.warn("Cannot found target reporter, rtbAdvertiser: {}", (Object)rtbAdvertiser);
            return;
        }
        String feedbackUrl = this.createBxmFeedbackUrl(clickTrackerLog, extParams, rtbMedia);
        try {
            reporter.report(clickTrackerLog, feedbackUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String createBxmFeedbackUrl(KeyValueMap clickTrackerLog, String extParams, RtbMedia rtbMedia) {
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.COMMON);
        map.setMt(Common.Mt.oCpxFeedbackForCommon.original());
        map.putIfNotBlank("bxmmedia", (String)clickTrackerLog.getFirst((Object)"bxmmedia"));
        map.putIfNotBlank("bxmadvertiser", (String)clickTrackerLog.getFirst((Object)"bxmadvertiser"));
        map.putIfNotBlank("bxmextra", (String)clickTrackerLog.getFirst((Object)"bxmextra"));
        map.putIfNotBlank("click_id", (String)clickTrackerLog.getFirst((Object)"click_id"));
        map.putIfNotBlank("conv_def", (String)clickTrackerLog.getFirst((Object)"conv_def"));
        map.putIfNotBlank("conv_ratio", (String)clickTrackerLog.getFirst((Object)"conv_ratio"));
        map.putIfNotBlank("ext_params", extParams);
        return map.createOpenLogRequestUri(this.properties.getOpenLogRequestOutDomain());
    }
}

