/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.baidu;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.exception.ReportFailException;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class BaiduReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(BaiduReporter.class);
    private final HttpClient httpClient;
    private static final String URL = "https://ug.baidu.com/attribute/outer/monitor/baidubox/click/bianxianmao/40";

    public BaiduReporter() {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) throws Exception {
        String reqid;
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)URL);
        String device = null;
        String imei = (String)clickLog.getFirst((Object)"imei");
        if (StringUtils.isNotBlank((String)imei)) {
            uriComponentsBuilder.replaceQueryParam("imei", new Object[]{imei});
            device = imei;
        }
        String imeiMd5 = (String)clickLog.getFirst((Object)"imei_md5");
        if (StringUtils.isBlank(device) && StringUtils.isNotBlank((String)imeiMd5)) {
            uriComponentsBuilder.replaceQueryParam("imei_md5", new Object[]{imeiMd5});
            device = imeiMd5;
        }
        String oaid = (String)clickLog.getFirst((Object)"oaid");
        if (StringUtils.isBlank((String)device) && StringUtils.isNotBlank((String)oaid)) {
            uriComponentsBuilder.replaceQueryParam("oaid", new Object[]{oaid});
            device = oaid;
        }
        String oaidMd5 = (String)clickLog.getFirst((Object)"oaid_md5");
        if (StringUtils.isBlank((String)device) && StringUtils.isNotBlank((String)oaidMd5)) {
            uriComponentsBuilder.replaceQueryParam("oaid_md5", new Object[]{oaidMd5});
            device = oaidMd5;
        }
        String androidId = (String)clickLog.getFirst((Object)"androidid");
        if (StringUtils.isBlank((String)device) && StringUtils.isNotBlank((String)androidId)) {
            uriComponentsBuilder.replaceQueryParam("android_id", new Object[]{androidId});
        }
        String clicKId = (String)clickLog.getFirst((Object)"click_id");
        String planId = null;
        if (StringUtils.isNotBlank((String)clicKId)) {
            try {
                planId = this.getUrlParams(clicKId).get("clkid");
            }
            catch (UnsupportedEncodingException e) {
                log.info("report sbgfjc urlDecode exception!");
            }
        }
        if (StringUtils.isBlank((String)(reqid = (String)clickLog.getFirst((Object)"reqid")))) {
            reqid = RandomStringUtils.randomAlphanumeric((int)8);
        }
        uriComponentsBuilder.replaceQueryParam("schema_type", new Object[]{1}).replaceQueryParam("channel", new Object[]{"bianxianmao"}).replaceQueryParam("flow_type", new Object[]{6}).replaceQueryParam("package_id", new Object[]{clickLog.getFirst((Object)"package_id")}).replaceQueryParam("app_name", new Object[]{"baidubox"}).replaceQueryParam("account_id", new Object[]{"32725"}).replaceQueryParam("app_type", new Object[]{"android"}).replaceQueryParam("conv_type", new Object[]{"invoke"}).replaceQueryParam("plan_id", new Object[]{StringUtils.isBlank((String)planId) ? clicKId : planId}).replaceQueryParam("reqid", new Object[]{reqid}).replaceQueryParam("add_time", new Object[]{System.currentTimeMillis()}).replaceQueryParam("callback_url", new Object[]{UrlHelper.urlEncode((String)bxmFeedbackUrl)});
        String reqUrl = uriComponentsBuilder.build().toString();
        HttpGet get = new HttpGet(reqUrl);
        try {
            HttpResponse res = this.httpClient.execute((HttpUriRequest)get);
            if (res.getStatusLine().getStatusCode() != 200) {
                String body = EntityUtils.toString((HttpEntity)res.getEntity());
                throw new ReportFailException(String.format("reportUrl:%s response:%s", reqUrl, body));
            }
        }
        finally {
            get.releaseConnection();
        }
        log.info("sbgfjcReportUrl:{}", (Object)reqUrl);
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.Sbgfjc;
    }

    private Map<String, String> getUrlParams(String url) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isBlank((String)url)) {
            return params;
        }
        String[] urlParts = URLDecoder.decode(url, "UTF-8").split("\\?");
        if (urlParts.length > 1) {
            String[] paramParts;
            for (String param : paramParts = urlParts[1].split("&")) {
                String[] keyValue = param.split("=");
                if (keyValue.length != 2) continue;
                String key = keyValue[0];
                String value = keyValue[1];
                params.put(key, value);
            }
        }
        return params;
    }
}

