/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.bxm;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class BxmmReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(BxmmReporter.class);
    private final OpenLogClient openLogClient;

    public BxmmReporter(OpenLogClient openLogClient) {
        this.openLogClient = openLogClient;
    }

    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        if (!this.isHitRatio(clickLog)) {
            return;
        }
        String url = UriComponentsBuilder.fromUriString((String)bxmFeedbackUrl).queryParam(RtbAdvertiser.BianXianMaoM.getTransferType(), new Object[]{"1"}).build().toString();
        this.openLogClient.asyncRequest(url);
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.BianXianMaoM;
    }

    private boolean isHitRatio(KeyValueMap m) {
        String convRatio = (String)m.getFirst((Object)"conv_ratio");
        if (StringUtils.isNotBlank((CharSequence)convRatio)) {
            double ratio = Double.parseDouble(convRatio);
            if (ratio >= 100.0) {
                return true;
            }
            double random = RandomUtils.nextDouble((double)0.0, (double)100.0);
            return random < ratio;
        }
        return false;
    }
}

