/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.dhh;

import com.bxm.adscounter.integration.taobao.TaobaoIntegration;
import com.bxm.adscounter.integration.taobao.TaobaoProperties;
import com.bxm.adscounter.integration.taobao.TaobaoRequest;
import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UrlHelper;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DhhReporter
implements Reporter {
    private final TaobaoIntegration taobaoIntegration;
    private final TaobaoProperties taobaoProperties;

    public DhhReporter(TaobaoIntegration taobaoIntegration, TaobaoProperties taobaoProperties) {
        this.taobaoIntegration = taobaoIntegration;
        this.taobaoProperties = taobaoProperties;
    }

    @Override
    public void report(KeyValueMap clickLog, String feedbackUrl) {
        String imei = (String)clickLog.getFirst((Object)"imei");
        String oaid = (String)clickLog.getFirst((Object)"oaid");
        String oaidMd5 = (String)clickLog.getFirst((Object)"oaid_md5");
        String idfa = (String)clickLog.getFirst((Object)"idfa");
        String app = (String)clickLog.getFirst((Object)"app");
        String taskId = (String)clickLog.getFirst((Object)"taskId");
        String channel = (String)clickLog.getFirst((Object)"channel");
        String advertisingSpaceId = (String)clickLog.getFirst((Object)"advertisingSpaceId");
        String adid = (String)clickLog.getFirst((Object)"adid");
        String cid = (String)clickLog.getFirst((Object)"cid");
        String adAgent = (String)clickLog.getFirst((Object)"adAgent");
        TaobaoRequest request = new TaobaoRequest();
        request.setReportUrl(this.taobaoProperties.getReportClickUrl()).setTaskId(taskId).setApp(app).setChannel(channel).setAdid(adid).setCid(cid).setAdAgent(adAgent).setAdvertisingSpaceId(advertisingSpaceId).setImei(imei).setOaid(oaid).setOaidMd5(oaidMd5).setIdfa(idfa).setCallbackUrl(UrlHelper.urlEncode((String)feedbackUrl)).setTimestamp(TypeHelper.castToString((Object)System.currentTimeMillis()));
        this.taobaoIntegration.report(request);
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.TAOBAO;
    }
}

