/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.didi;

import com.bxm.adscounter.integration.didi.DidiIntegration;
import com.bxm.adscounter.integration.didi.DidiRequest;
import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DidiReporter
implements Reporter {
    private final DidiIntegration didiIntegration;

    public DidiReporter(DidiIntegration didiIntegration) {
        this.didiIntegration = didiIntegration;
    }

    @Override
    public void report(KeyValueMap clickLog, String feedbackUrl) {
        DidiRequest request = new DidiRequest();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String idfa = (String)clickLog.getFirst((Object)"idfa");
        String idfaMd5 = (String)clickLog.getFirst((Object)"idfa_md5");
        String deviceOs = StringUtils.isBlank((String)idfa) && StringUtils.isBlank((String)idfaMd5) ? "android" : "IOS";
        parameters.put("adx", clickLog.getFirst((Object)"adx"));
        parameters.put("device_os", deviceOs);
        parameters.put("ip", clickLog.getFirst((Object)"ip"));
        parameters.put("client_time", TypeHelper.castToString((Object)System.currentTimeMillis()));
        parameters.put("ua", clickLog.getFirst((Object)"ua"));
        parameters.put("callback_url", UrlHelper.urlEncode((String)feedbackUrl));
        parameters.put("account_id", clickLog.getFirst((Object)"account_id"));
        parameters.put("product_id", clickLog.getFirst((Object)"product_id"));
        parameters.put("imei", clickLog.getFirst((Object)"imei"));
        parameters.put("imei_md5", clickLog.getFirst((Object)"imei_md5"));
        parameters.put("idfa", idfa);
        parameters.put("idfa_md5", idfaMd5);
        parameters.put("oaid", clickLog.getFirst((Object)"oaid"));
        parameters.put("oaid_md5", clickLog.getFirst((Object)"oaid_md5"));
        parameters.put("android_id_md5", clickLog.getFirst((Object)"androidid_md5"));
        parameters.put("level_two_media", clickLog.getFirst((Object)"level_two_media"));
        parameters.put("ad_target", clickLog.getFirst((Object)"ad_target"));
        parameters.put("lp_type", clickLog.getFirst((Object)"lp_type"));
        parameters.put("ad_team", clickLog.getFirst((Object)"ad_team"));
        parameters.put("dchn", clickLog.getFirst((Object)"dchn"));
        request.setParameters(parameters);
        this.didiIntegration.report(request);
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.DIDI;
    }
}

