/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.eleme;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class ElemeReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(ElemeReporter.class);
    private final HttpClient httpClient;
    private static final String URL = "https://alsc-ug-monitor-callback.alibaba.com/streamMonitor/click";
    private static final String DEFAULT_SALT = "3f557aac72e247de7e6c47027b6fb7a7";

    public ElemeReporter() {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        boolean isIos = StringUtils.isNotBlank((String)((String)clickLog.getFirst((Object)"idfa"))) || StringUtils.isNotBlank((String)((String)clickLog.getFirst((Object)"idfa_md5")));
        String salt = (String)clickLog.getFirst((Object)"salt");
        String task_id = (String)clickLog.getFirst((Object)"task_id");
        String propagation_site = (String)clickLog.getFirst((Object)"propagation_site");
        String task_type = (String)clickLog.getFirst((Object)"task_type");
        if (StringUtils.isBlank((String)salt)) {
            salt = DEFAULT_SALT;
        }
        if (StringUtils.isBlank((String)task_id)) {
            log.warn("Eleme report cannot found 'task_id' from click url!");
            return;
        }
        if (StringUtils.isBlank((String)propagation_site)) {
            log.warn("Eleme report cannot found 'propagation_site' from click url!");
            return;
        }
        if (StringUtils.isBlank((String)task_type)) {
            log.warn("Eleme report cannot found 'task_type' from click url!");
            return;
        }
        String requestId = RandomStringUtils.randomAlphanumeric((int)8);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)URL).replaceQueryParam("request_id", new Object[]{requestId}).replaceQueryParam("imei", new Object[]{this.getDefault(clickLog.getFirst((Object)"imei"))}).replaceQueryParam("imei_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"imei"))}).replaceQueryParam("oaid", new Object[]{this.getDefault(clickLog.getFirst((Object)"oaid"))}).replaceQueryParam("oaid_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"oaid_md5"))}).replaceQueryParam("idfa", new Object[]{this.getDefault(clickLog.getFirst((Object)"idfa"))}).replaceQueryParam("idfa_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"idfa_md5"))}).replaceQueryParam("os", new Object[]{isIos ? 1 : 0}).replaceQueryParam("bxmId", new Object[]{requestId}).replaceQueryParam("mts", new Object[]{System.currentTimeMillis()}).replaceQueryParam("medium_source", new Object[]{-1}).replaceQueryParam("delivery_type", new Object[]{10}).replaceQueryParam("ascribe_type", new Object[]{3}).replaceQueryParam("demander_type", new Object[]{5}).replaceQueryParam("biz_type", new Object[]{2}).replaceQueryParam("task_id", new Object[]{task_id}).replaceQueryParam("propagator_id", new Object[]{"86457915D5205511D4C614FB283B347E"}).replaceQueryParam("propagation_site", new Object[]{propagation_site}).replaceQueryParam("task_type", new Object[]{task_type}).replaceQueryParam("callback_url", new Object[]{UrlHelper.urlEncode((String)bxmFeedbackUrl)});
        String signature = this.getSignature(uriComponentsBuilder, salt);
        String reqUrl = uriComponentsBuilder.replaceQueryParam("signature", new Object[]{signature}).build().toString();
        HttpGet get = new HttpGet(reqUrl);
        try {
            if (log.isInfoEnabled()) {
                log.info("{} - eleme reporting: {}", (Object)requestId, (Object)reqUrl);
            }
            HttpResponse res = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            if (log.isInfoEnabled()) {
                log.info("{} - eleme response: {}", (Object)requestId, (Object)body);
            }
        }
        catch (IOException e) {
            log.error("{} - eleme report occur exception: {}", (Object)requestId, (Object)e.getMessage());
        }
        finally {
            get.releaseConnection();
        }
    }

    private String getSignature(UriComponentsBuilder uriComponentsBuilder, String salt) {
        return DigestUtils.md5Hex((String)(uriComponentsBuilder.build().toString() + salt));
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.Eleme;
    }
}

