/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.elme2;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class ElemeTwoReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(ElemeTwoReporter.class);
    private final HttpClient httpClient;
    private static final String URL = "https://o2o-ad-clicking.alibaba.com/logCenter/mediumClick";

    public ElemeTwoReporter() {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        boolean isIos = StringUtils.isNotBlank((String)((String)clickLog.getFirst((Object)"idfa"))) || StringUtils.isNotBlank((String)((String)clickLog.getFirst((Object)"idfa_md5")));
        String requestId = (String)clickLog.getFirst((Object)"bxmid");
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)URL).replaceQueryParam("action_id", new Object[]{clickLog.getFirst((Object)"click_id")}).replaceQueryParam("request_id", new Object[]{requestId}).replaceQueryParam("rta_id", new Object[]{Optional.ofNullable(clickLog.getFirst((Object)"rta_id")).orElse("__RTA_ID__")}).replaceQueryParam("adv_id", new Object[]{Optional.ofNullable(clickLog.getFirst((Object)"adv_id")).orElse("__ADVERTISER_ID__")}).replaceQueryParam("campaign_id", new Object[]{Optional.ofNullable(clickLog.getFirst((Object)"campaign_id")).orElse("__CAMPAIGN_ID__")}).replaceQueryParam("adid", new Object[]{Optional.ofNullable(clickLog.getFirst((Object)"adid")).orElse("__AD_ID__")}).replaceQueryParam("cid", new Object[]{Optional.ofNullable(clickLog.getFirst((Object)"cid")).orElse("__CID__")}).replaceQueryParam("os", new Object[]{isIos ? 1 : 2}).replaceQueryParam("imei", new Object[]{this.getDefault(clickLog.getFirst((Object)"imei"))}).replaceQueryParam("imei_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"imei_md5"))}).replaceQueryParam("oaid", new Object[]{this.getDefault(clickLog.getFirst((Object)"oaid"))}).replaceQueryParam("oaid_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"oaid_md5"))}).replaceQueryParam("android_id", new Object[]{this.getDefault(clickLog.getFirst((Object)"androidid"))}).replaceQueryParam("android_id_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"androidid_md5"))}).replaceQueryParam("idfa", new Object[]{this.getDefault(clickLog.getFirst((Object)"idfa"))}).replaceQueryParam("idfa_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"idfa_md5"))}).replaceQueryParam("callback_url", new Object[]{UrlHelper.urlEncode((String)bxmFeedbackUrl)}).replaceQueryParam("action_type", new Object[]{1}).replaceQueryParam("mts", new Object[]{System.currentTimeMillis()}).replaceQueryParam("medium_source", new Object[]{Optional.ofNullable(clickLog.getFirst((Object)"medium_source")).orElse("__MEDIUM_SOURCE__")});
        String reqUrl = uriComponentsBuilder.build().toString();
        HttpGet get = new HttpGet(reqUrl);
        try {
            log.info("{} - eleme2 reporting: {}", (Object)requestId, (Object)reqUrl);
            HttpResponse res = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            log.info("{} - eleme2 response: {}", (Object)requestId, (Object)body);
        }
        catch (IOException e) {
            log.error("{} - eleme2 report occur exception: {}", (Object)requestId, (Object)e.getMessage());
        }
        finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.Elemedjjc;
    }
}

