/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.gaode;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UrlHelper;
import java.io.IOException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class GaodeReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(GaodeReporter.class);
    private static final String URL = "http://amap-ocpx-online.amap.com/ws/channel/common-device-infos";
    private final HttpClient httpClient;
    private static final String ANDROID_SOURCE = "bianxianmao_wy_bxm_tt_01";
    private static final String IOS_SOURCE = "bianxianmao_wy_bxm_tt_02";

    public GaodeReporter() {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        boolean isIos = false;
        if (StringUtils.isNotBlank((String)((String)clickLog.getFirst((Object)"idfa"))) || StringUtils.isNotBlank((String)((String)clickLog.getFirst((Object)"idfa_md5")))) {
            isIos = true;
        }
        String requestId = RandomStringUtils.randomAlphanumeric((int)8);
        String reqUrl = UriComponentsBuilder.fromUriString((String)URL).replaceQueryParam("source", new Object[]{isIos ? IOS_SOURCE : ANDROID_SOURCE}).replaceQueryParam("imei", new Object[]{this.getDefault(clickLog.getFirst((Object)"imei"))}).replaceQueryParam("oaid", new Object[]{this.getDefault(clickLog.getFirst((Object)"oaid"))}).replaceQueryParam("oaid_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"oaid_md5"))}).replaceQueryParam("idfa", new Object[]{this.getDefault(clickLog.getFirst((Object)"idfa"))}).replaceQueryParam("idfa_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"idfa_md5"))}).replaceQueryParam("callback", new Object[]{this.getDefault(UrlHelper.urlEncode((String)bxmFeedbackUrl))}).replaceQueryParam("bxmId", new Object[]{requestId}).toUriString();
        HttpGet get = new HttpGet(reqUrl);
        try {
            if (log.isInfoEnabled()) {
                log.info("{} - gaode reporting: {}", (Object)requestId, (Object)reqUrl);
            }
            HttpResponse res = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            if (log.isInfoEnabled()) {
                log.info("{} - gaode response: {}", (Object)requestId, (Object)body);
            }
        }
        catch (IOException e) {
            log.error("{} - gaode report occur exception: {}", (Object)requestId, (Object)e.getMessage());
        }
        finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.GaoDe;
    }
}

