/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.imusic;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ImusicReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(ImusicReporter.class);
    private static final String URL = "https://api.yinliai.com/ads/clickTracker?request_id=__REQUEST_ID__&plan_id=__PLAN_ID__&ip=__IP__&ua=__UA__&os=__OS__&imei=__IMEI__&imei_md5=__IMEI_MD5__&androidid=__ANDROID_ID__&androidid_md5=__ANDROID_ID_MD5__&oaid=__OAID__&oaid_md5=__OAID_MD5__&idfa=__IDFA__&idfa_md5=__IDFA_MD5__&gaid=__GAID__&gaid_md5=__GAID_MD5__&medium_logic_id=__MEDIUM_LOGIC_ID__&time=__TIME__&callback=__CALLBACK__";
    private final HttpClient httpClient;

    public ImusicReporter() {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        String requestId = UUIDHelper.generate();
        String reqUrl = URL.replaceAll("__REQUEST_ID__", requestId).replaceAll("__PLAN_ID__", this.getDefault(clickLog.getFirst((Object)"adid"))).replaceAll("__IMEI__", this.getDefault(clickLog.getFirst((Object)"imei"))).replaceAll("__IDFA__", this.getDefault(clickLog.getFirst((Object)"idfa"))).replaceAll("__OAID__", this.getDefault(clickLog.getFirst((Object)"oaid"))).replaceAll("__OAID_MD5__", this.getDefault(clickLog.getFirst((Object)"oaid_md5"))).replaceAll("__OS__", this.getDefault(UrlHelper.urlEncode((String)((String)clickLog.getFirst((Object)"os"))))).replaceAll("__IP__", this.getDefault(clickLog.getFirst((Object)"ip"))).replaceAll("__UA__", this.getDefault(UrlHelper.urlEncode((String)((String)clickLog.getFirst((Object)"ua"))))).replaceAll("__CALLBACK__", this.getDefault(UrlHelper.urlEncode((String)bxmFeedbackUrl))).replaceAll("__TIME__", this.getDefault(System.currentTimeMillis())).replaceAll("__ANDROID_ID__", this.getDefault(clickLog.getFirst((Object)"androidid"))).replaceAll("__MEDIUM_LOGIC_ID__", this.getDefault(UrlHelper.urlEncode((String)((String)clickLog.getFirst((Object)"click_id"))))).replaceAll("__IMEI_MD5__", this.getDefault(clickLog.getFirst((Object)"imei_md5"))).replaceAll("__IDFA_MD5__", this.getDefault(clickLog.getFirst((Object)"idfa_md5"))).replaceAll("__ANDROID_ID_MD5__", this.getDefault(clickLog.getFirst((Object)"androidid_md5"))).replaceAll("__GAID__", this.getDefault(clickLog.getFirst((Object)"gaid"))).replaceAll("__GAID_MD5__", this.getDefault(clickLog.getFirst((Object)"gaid_md5")));
        HttpGet get = new HttpGet(reqUrl);
        try {
            if (log.isInfoEnabled()) {
                log.info("{} - iMusic reporting: {}", (Object)requestId, (Object)reqUrl);
            }
            HttpResponse res = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            if (log.isInfoEnabled()) {
                log.info("{} - iMusic response: {}", (Object)requestId, (Object)body);
            }
        }
        catch (IOException e) {
            log.error("{} - iMusic report occur exception: {}", (Object)requestId, (Object)e.getMessage());
        }
        finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.iMusic;
    }
}

