/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.jd;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.constant.OcpxKeyGenerator;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JdReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(JdReporter.class);
    private final JedisUpdater jedisUpdater;
    private static final Integer EXPIRE_SECOND = 172800;

    public JdReporter(JedisUpdater jedisUpdater) {
        this.jedisUpdater = jedisUpdater;
    }

    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        String oaid = (String)clickLog.getFirst((Object)"oaid");
        String idfa = (String)clickLog.getFirst((Object)"idfa");
        String oaidMd5 = (String)clickLog.getFirst((Object)"oaid_md5");
        String idfaMd5 = (String)clickLog.getFirst((Object)"idfa_md5");
        if (StringUtils.isNotBlank((String)oaid)) {
            this.jedisUpdater.update(OcpxKeyGenerator.stringOcpxDeviceCache(this.md5(oaid)), (Object)clickLog, EXPIRE_SECOND.intValue());
            this.jedisUpdater.update(OcpxKeyGenerator.stringOcpxDeviceCache(this.md5Default(oaid)), (Object)clickLog, EXPIRE_SECOND.intValue());
        }
        if (StringUtils.isNotBlank((String)idfa)) {
            this.jedisUpdater.update(OcpxKeyGenerator.stringOcpxDeviceCache(this.md5(idfa)), (Object)clickLog, EXPIRE_SECOND.intValue());
            this.jedisUpdater.update(OcpxKeyGenerator.stringOcpxDeviceCache(this.md5Default(idfa)), (Object)clickLog, EXPIRE_SECOND.intValue());
        }
        if (StringUtils.isNotBlank((String)oaidMd5)) {
            this.jedisUpdater.update(OcpxKeyGenerator.stringOcpxDeviceCache(oaidMd5.toUpperCase()), (Object)clickLog, EXPIRE_SECOND.intValue());
        }
        if (StringUtils.isNotBlank((String)idfaMd5)) {
            this.jedisUpdater.update(OcpxKeyGenerator.stringOcpxDeviceCache(idfaMd5.toUpperCase()), (Object)clickLog, EXPIRE_SECOND.intValue());
        }
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.Jd;
    }

    private String md5(String device) {
        return DigestUtils.md5Hex((String)device.toUpperCase()).toUpperCase();
    }

    private String md5Default(String device) {
        return DigestUtils.md5Hex((String)device).toUpperCase();
    }
}

