/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.meituan;

import com.bxm.adscounter.integration.meituan.MeituanFeedback;
import com.bxm.adscounter.integration.meituan.MeituanIntegration;
import com.bxm.adscounter.integration.meituan.MeituanProperties;
import com.bxm.adscounter.integration.meituan.MeituanRequest;
import com.bxm.adscounter.integration.meituan.MeituanResponse;
import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.model.constant.Constants;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.logging.extension.CustomLoggingWriter;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class MeituanReporter
implements Reporter {
    private static final Pattern MACRO_REGX = Pattern.compile("^__.*__$");
    private final MeituanProperties meituanProperties;
    private final MeituanIntegration meituanIntegration;
    private final MeituanFeedback meituanFeedback;

    public MeituanReporter(MeituanProperties meituanProperties, MeituanIntegration meituanIntegration, @Qualifier(value="customLoggingWriterForOcpxClickReporting") CustomLoggingWriter customLoggingWriter) {
        this.meituanProperties = meituanProperties;
        this.meituanIntegration = meituanIntegration;
        this.meituanFeedback = new DefaultMeituanFeedbackImpl(customLoggingWriter);
    }

    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        String first;
        String source = (String)clickLog.getFirst((Object)"source");
        if (StringUtils.isBlank((String)source)) {
            return;
        }
        String idfaMd5 = this.clearMacroValue((String)clickLog.getFirst((Object)"idfa_md5"));
        String imeiMd5 = this.clearMacroValue((String)clickLog.getFirst((Object)"imei_md5"));
        String oaid = this.clearMacroValue((String)clickLog.getFirst((Object)"oaid"));
        String oaidMd5 = this.clearMacroValue((String)clickLog.getFirst((Object)"oaid_md5"));
        String actionTime = Optional.ofNullable(clickLog.getFirst((Object)"action_time")).filter(StringUtils::isNotBlank).orElseGet(() -> TypeHelper.castToString((Object)System.currentTimeMillis()));
        String os = Optional.ofNullable(clickLog.getFirst((Object)"x_os")).filter(StringUtils::isNotBlank).orElseGet(() -> StringUtils.isNotBlank((String)idfaMd5) ? "ios" : "android");
        String trackType = (String)clickLog.getFirst((Object)"trackType");
        String medium = (String)clickLog.getFirst((Object)"medium");
        String csite = (String)clickLog.getFirst((Object)"csite");
        String promotionType = (String)clickLog.getFirst((Object)"promotion_type");
        String monitorType = (String)clickLog.getFirst((Object)"monitor_type");
        MeituanRequest request = new MeituanRequest().setSource(source).setAppType(os).setImeiMd5(imeiMd5).setIdfaMd5(idfaMd5).setOaid(oaid).setOaidMd5(oaidMd5);
        if (RtbAdvertiser.MeiTuanYouXuan == this.rtbAdvertiser()) {
            request.setReportUrl(this.meituanProperties.getYouXuanReportClickUrl());
        } else if (Objects.equals(Constants.TrackType.EXPOSURE.toString(), trackType)) {
            request.setReportUrl(this.meituanProperties.getReportExposureUrl());
        } else {
            request.setReportUrl(this.meituanProperties.getReportClickUrl());
        }
        request.addExtend("app", "group");
        request.addExtend("coderesp", "true");
        request.addExtend("monitor_type", StringUtils.isBlank((String)monitorType) ? "click" : monitorType);
        request.addExtend("mt_channel", "meituanunion");
        request.addExtend("action_time", TypeHelper.castToString((Object)actionTime));
        request.addExtend("medium", medium);
        request.addExtend("csite", csite);
        request.addExtend("promotion_type", promotionType);
        if (RtbMedia.QUTOUTIAO.getType().equals(clickLog.getFirst((Object)"bxmmedia")) && StringUtils.isNotBlank((String)(first = (String)clickLog.getFirst((Object)"click_id")))) {
            String s = UrlHelper.urlEncode((String)UrlHelper.urlEncode((String)first));
            bxmFeedbackUrl = UriComponentsBuilder.fromUriString((String)bxmFeedbackUrl).replaceQueryParam("click_id", new Object[]{s}).build().toString();
        }
        request.setFeedbackUrl(UrlHelper.urlEncode((String)bxmFeedbackUrl));
        this.meituanIntegration.report(request, this.meituanFeedback);
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.MeiTuan;
    }

    private String clearMacroValue(String str) {
        if (StringUtils.isNotBlank((String)str) && MACRO_REGX.matcher(str).find()) {
            return "";
        }
        return str;
    }

    private static class DefaultMeituanFeedbackImpl
    implements MeituanFeedback {
        private final CustomLoggingWriter customLoggingWriter;

        private DefaultMeituanFeedbackImpl(CustomLoggingWriter customLoggingWriter) {
            this.customLoggingWriter = customLoggingWriter;
        }

        public void call(MeituanRequest request, MeituanResponse response, String requestUri, Throwable throwable) {
            if (StringUtils.isBlank((String)requestUri)) {
                return;
            }
            UriComponents build = UriComponentsBuilder.fromUriString((String)requestUri).build();
            MultiValueMap params = build.getQueryParams();
            HashMap writeParams = Maps.newHashMap();
            for (Map.Entry entry : params.entrySet()) {
                List list = (List)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)list)) continue;
                writeParams.put(entry.getKey(), list.get(0));
            }
            writeParams.put("url", requestUri);
            writeParams.put("responseBody", JsonHelper.convert((Object)response));
            if (Objects.nonNull(throwable)) {
                writeParams.put("exception", throwable.getMessage());
            }
            this.customLoggingWriter.write((Map)writeParams);
        }
    }
}

