/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.meituanocps;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.constant.OcpxKeyGenerator;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MeituanOcpsReporter
implements Reporter {
    private final JedisUpdater jedisUpdater;
    private static final Integer EXPIRE_SECOND = 172800;

    public MeituanOcpsReporter(JedisUpdater jedisUpdater) {
        this.jedisUpdater = jedisUpdater;
    }

    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        String oaid = (String)clickLog.getFirst((Object)"oaid");
        String oaidMd5 = (String)clickLog.getFirst((Object)"oaid_md5");
        if (StringUtils.isNotBlank((String)oaidMd5)) {
            this.jedisUpdater.update(OcpxKeyGenerator.stringMeituanOcpsCache(oaidMd5), (Object)clickLog, EXPIRE_SECOND.intValue());
        } else if (StringUtils.isNotBlank((String)oaid)) {
            this.jedisUpdater.update(OcpxKeyGenerator.stringMeituanOcpsCache(DigestUtils.md5Hex((String)oaid.toUpperCase()).toUpperCase()), (Object)clickLog, EXPIRE_SECOND.intValue());
        }
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.MeiTuanOcps;
    }
}

