/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.qczj;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.exception.ReportFailException;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.adscounter.ocpx.report.qczj.QczjProperties;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UUIDHelper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;

@Configuration
@EnableConfigurationProperties(value={QczjProperties.class})
public class QczjReport
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(QczjReport.class);
    private final HttpClient httpClient;
    private final QczjProperties properties;

    public QczjReport(QczjProperties properties) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(10000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("requestId", UUIDHelper.generate());
        params.put("requestTime", System.currentTimeMillis());
        String oaid = (String)clickLog.getFirst((Object)"oaid");
        if (StringUtils.isBlank((String)oaid)) {
            oaid = (String)clickLog.getFirst((Object)"oaid_md5");
        }
        if (StringUtils.isBlank((String)oaid)) {
            log.warn("qczjReport oaid is null");
            return;
        }
        params.put("oaid", oaid);
        params.put("channel", clickLog.getFirst((Object)"channel"));
        params.put("mediaName", clickLog.getFirst((Object)"mediaName"));
        String trackType = (String)clickLog.getFirst((Object)"trackType");
        params.put("eventType", "1".equals(trackType) ? "2" : "1");
        params.put("sign", this.sign(params));
        HttpPost post = new HttpPost(this.properties.getUrl());
        post.addHeader("Content-Type", "application/json;charset=UTF-8");
        post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert(params), StandardCharsets.UTF_8));
        try {
            HttpResponse execute = this.httpClient.execute((HttpUriRequest)post);
            if (execute.getStatusLine().getStatusCode() != HttpStatus.OK.value()) {
                throw new ReportFailException(String.format("\u54cd\u5e94\u5931\u8d25\uff0cstatusCode:%s", execute.getStatusLine().getStatusCode()));
            }
            String body = EntityUtils.toString((HttpEntity)execute.getEntity(), (Charset)StandardCharsets.UTF_8);
            Res res = (Res)JsonHelper.convert((String)body, Res.class);
            if (!res.isTarget()) {
                throw new ReportFailException(String.format("\u4e0a\u62a5\u5931\u8d25\uff0cmessage:%s", res.getMessage()));
            }
        }
        finally {
            post.abort();
        }
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.Qczj;
    }

    private String sign(Map<String, Object> params) {
        StringBuilder query = new StringBuilder(this.properties.getSecret());
        query.append(params.get("requestId"));
        query.append(params.get("requestTime"));
        query.append(params.get("oaid"));
        query.append(params.get("channel"));
        return DigestUtils.md5Hex((String)query.toString());
    }

    private static class Res {
        private Integer returncode = -1;
        private String message;

        public boolean isTarget() {
            return this.returncode == 0;
        }

        public Integer getReturncode() {
            return this.returncode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setReturncode(Integer returncode) {
            this.returncode = returncode;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Res)) {
                return false;
            }
            Res other = (Res)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$returncode = this.getReturncode();
            Integer other$returncode = other.getReturncode();
            if (this$returncode == null ? other$returncode != null : !((Object)this$returncode).equals(other$returncode)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Res;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $returncode = this.getReturncode();
            result = result * 59 + ($returncode == null ? 43 : ((Object)$returncode).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        public String toString() {
            return "QczjReport.Res(returncode=" + this.getReturncode() + ", message=" + this.getMessage() + ")";
        }
    }
}

