/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.qihang;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.exception.ReportFailException;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.adscounter.ocpx.report.qihang.QiHangProperties;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.UUIDHelper;
import com.bxm.warcar.utils.UrlHelper;
import com.bxm.warcar.utils.http.OkHttpUtils;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={QiHangProperties.class})
public class QiHangReport
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(QiHangReport.class);
    private final HttpClient httpClient;
    private final QiHangProperties properties;

    public QiHangReport(QiHangProperties properties) {
        this.properties = properties;
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String trackType = (String)clickLog.getFirst((Object)"trackType");
        params.put("action", "1".equals(trackType) ? "2" : "1");
        String os = Optional.ofNullable(clickLog.getFirst((Object)"x_os")).filter(StringUtils::isNotBlank).orElseGet(() -> StringUtils.isNotBlank((String)((String)clickLog.getFirst((Object)"idfa_md5"))) ? "1" : "0");
        params.put("os", os);
        params.put("oaidMd5", clickLog.getFirst((Object)"oaid_md5"));
        params.put("oaid", clickLog.getFirst((Object)"oaid"));
        params.put("imeiMd5", clickLog.getFirst((Object)"imei_md5"));
        params.put("imei", clickLog.getFirst((Object)"imei"));
        params.put("idfa", clickLog.getFirst((Object)"idfa"));
        params.put("idfaMd5", clickLog.getFirst((Object)"idfa_md5"));
        params.put("caid", clickLog.getFirst((Object)"caid"));
        params.put("caidMd5", "");
        params.put("traceId", UUIDHelper.generate());
        params.put("callbackUrl", UrlHelper.urlEncode((String)bxmFeedbackUrl));
        params.put("adGroupId", clickLog.getFirst((Object)"adGroupId"));
        params.put("adid", clickLog.getFirst((Object)"adid"));
        params.put("cid", clickLog.getFirst((Object)"cid"));
        params.put("price", clickLog.getFirst((Object)"price"));
        params.put("priceRatio", clickLog.getFirst((Object)"priceRatio"));
        params.put("materialId", clickLog.getFirst((Object)"materialId"));
        params.put("adxType", clickLog.getFirst((Object)"adxType"));
        params.put("taskId", clickLog.getFirst((Object)"taskId"));
        params.put("bidSubId", clickLog.getFirst((Object)"bidSubId"));
        params.put("bidType", clickLog.getFirst((Object)"bidType"));
        params.put("channel", clickLog.getFirst((Object)"channel"));
        params.put("advertisingSpaceId", clickLog.getFirst((Object)"advertisingSpaceId"));
        params.put("impPosition", clickLog.getFirst((Object)"impPosition"));
        params.put("adSpaceCategory", clickLog.getFirst((Object)"adSpaceCategory"));
        params.put("extraInfo", clickLog.getFirst((Object)"extraInfo"));
        String reportUrl = OkHttpUtils.appendParams((String)this.properties.getUrl(), params);
        HttpGet get = new HttpGet(reportUrl);
        try {
            HttpResponse execute = this.httpClient.execute((HttpUriRequest)get);
            int statusCode = execute.getStatusLine().getStatusCode();
            String responseBody = EntityUtils.toString((HttpEntity)execute.getEntity());
            if (statusCode != 200) {
                throw new ReportFailException(String.format("qiHangReportUrl:%s - StatusCode:%s", reportUrl, statusCode));
            }
            if (!"\"success\"".equals(responseBody)) {
                throw new ReportFailException(String.format("qiHangReportUrl:%s - StatusCode:%s - body:%s", reportUrl, statusCode, responseBody));
            }
            log.info("success qiHangReportUrl: {}", (Object)reportUrl);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.QiHang;
    }
}

