/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.shoujibaidu;

import com.alibaba.fastjson.JSON;
import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.adscounter.ocpx.report.shoujibaidu.ShouJiBaiDuProperties;
import com.bxm.openlog.sdk.KeyValueMap;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
@EnableConfigurationProperties(value={ShouJiBaiDuProperties.class})
public class ShouJiBaiDuReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(ShouJiBaiDuReporter.class);
    private HttpClient httpClient;
    private ShouJiBaiDuProperties properties;

    public ShouJiBaiDuReporter(ShouJiBaiDuProperties shouJiBaiDuProperties) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        this.properties = shouJiBaiDuProperties;
    }

    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        try {
            HttpRequestBase request = this.buildRequest(clickLog);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error("ShouJiBaiDu report error request:{},status:{} ", (Object)request, (Object)statusCode);
                return;
            }
            String data = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            BaiduRtaResponse rtaResponse = (BaiduRtaResponse)JSON.parseObject((String)data, BaiduRtaResponse.class);
            if (rtaResponse == null || !rtaResponse.isTarget()) {
                return;
            }
            bxmFeedbackUrl = bxmFeedbackUrl + "&" + RtbAdvertiser.ShouJiBaiDu.getTransferType() + "=1";
            response = this.httpClient.execute((HttpUriRequest)new HttpGet(bxmFeedbackUrl));
            EntityUtils.consume((HttpEntity)response.getEntity());
            statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error("ShouJiBaiDu openlog error url:{},status:{} ", (Object)bxmFeedbackUrl, (Object)statusCode);
            }
        }
        catch (Exception e) {
            log.error("ShouJiBaiDu error ", (Throwable)e);
        }
    }

    public HttpRequestBase buildRequest(KeyValueMap clickLog) {
        String idfa;
        String oaid;
        String url = this.properties.getUrl();
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"version", (Object)"1");
        params.add((Object)"channel", (Object)this.properties.getChannel());
        params.add((Object)"type", (Object)this.properties.getType());
        params.add((Object)"time", (Object)String.valueOf(System.currentTimeMillis() / 1000L));
        String imeiMd5 = (String)clickLog.getFirst((Object)"imei_md5");
        if (StringUtils.isNotBlank((String)imeiMd5)) {
            params.add((Object)"imei_md5", (Object)imeiMd5);
        }
        if (StringUtils.isNotBlank((String)(oaid = (String)clickLog.getFirst((Object)"oaid")))) {
            params.add((Object)"oaid", (Object)oaid);
        }
        if (StringUtils.isNotBlank((String)(idfa = (String)clickLog.getFirst((Object)"idfa")))) {
            params.add((Object)"idfa", (Object)idfa);
        }
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)url).replaceQueryParams((MultiValueMap)params);
        String sign = this.signature((MultiValueMap<String, String>)params);
        uriComponentsBuilder.replaceQueryParam("sign", new Object[]{sign});
        return new HttpGet(uriComponentsBuilder.build().toString());
    }

    private String signature(MultiValueMap<String, String> params) {
        TreeMap treeMap = new TreeMap(params.toSingleValueMap());
        StringBuilder s = new StringBuilder();
        for (Map.Entry entry : treeMap.entrySet()) {
            if (!StringUtils.isNotBlank((String)((String)entry.getValue()))) continue;
            s.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        s.append(this.properties.getToken());
        return DigestUtils.md5Hex((String)s.toString()).toLowerCase();
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.ShouJiBaiDu;
    }

    private static class BaiduRtaResponse {
        private String errno;
        private String msg;
        private String data;

        public boolean isTarget() {
            return StringUtils.equals((String)"1", (String)this.data);
        }

        public String getErrno() {
            return this.errno;
        }

        public String getMsg() {
            return this.msg;
        }

        public String getData() {
            return this.data;
        }

        public void setErrno(String errno) {
            this.errno = errno;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setData(String data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaiduRtaResponse)) {
                return false;
            }
            BaiduRtaResponse other = (BaiduRtaResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$errno = this.getErrno();
            String other$errno = other.getErrno();
            if (this$errno == null ? other$errno != null : !this$errno.equals(other$errno)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BaiduRtaResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $errno = this.getErrno();
            result = result * 59 + ($errno == null ? 43 : $errno.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "ShouJiBaiDuReporter.BaiduRtaResponse(errno=" + this.getErrno() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
        }
    }
}

