/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.ocpx.report.taobaovegas;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.ocpx.report.Reporter;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.pangu.rta.common.RtaRequest;
import com.bxm.pangu.rta.common.taobao_vegas.TaobaoVegasRtaClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class TaobaoVegasReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(TaobaoVegasReporter.class);
    private final TaobaoVegasRtaClient taobaoVegasRtaClient;
    private final OpenLogClient openLogClient;

    public TaobaoVegasReporter(TaobaoVegasRtaClient taobaoVegasRtaClient, OpenLogClient openLogClient) {
        this.taobaoVegasRtaClient = taobaoVegasRtaClient;
        this.openLogClient = openLogClient;
    }

    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        String param = TaobaoVegasReporter.createParam(clickLog);
        RtaRequest request = TaobaoVegasReporter.createRtaRequest(clickLog, param);
        if (this.taobaoVegasRtaClient.isTarget(request)) {
            String callback = UriComponentsBuilder.fromUriString((String)bxmFeedbackUrl).queryParam(this.rtbAdvertiser().getTransferType(), new Object[]{"1"}).build().toString();
            this.openLogClient.asyncRequest(callback, fallback -> log.warn("{} - occur exception: {}", (Object)fallback.getUrl(), (Object)fallback.getException()));
        }
    }

    private static String createParam(KeyValueMap clickLog) {
        return StringUtils.join((Object[])new String[]{(String)clickLog.getFirst((Object)"relation_id"), (String)clickLog.getFirst((Object)"special_id"), (String)clickLog.getFirst((Object)"thor_biz_code"), (String)clickLog.getFirst((Object)"pid"), (String)clickLog.getFirst((Object)"appKey"), (String)clickLog.getFirst((Object)"appSecret")}, (String)"|");
    }

    private static RtaRequest createRtaRequest(KeyValueMap clickLog, String param) {
        return new RtaRequest().setParam(param).setImei((String)clickLog.getFirst((Object)"imei")).setImei_md5((String)clickLog.getFirst((Object)"imei_md5")).setOaid((String)clickLog.getFirst((Object)"oaid")).setOaid_md5((String)clickLog.getFirst((Object)"oaid_md5")).setIdfa((String)clickLog.getFirst((Object)"idfa")).setIdfa_md5((String)clickLog.getFirst((Object)"idfa_md5"));
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.TaobaoVegas;
    }
}

