/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration.autoconfigure;

import com.bxm.adscounter.integration.didi.DidiIntegration;
import com.bxm.adscounter.integration.didi.DidiIntegrationImpl;
import com.bxm.adscounter.integration.didi.DidiProperties;
import com.bxm.adscounter.integration.meituan.MeituanIntegration;
import com.bxm.adscounter.integration.meituan.MeituanIntegrationImpl;
import com.bxm.adscounter.integration.meituan.MeituanProperties;
import com.bxm.adscounter.integration.taobao.TaobaoIntegration;
import com.bxm.adscounter.integration.taobao.TaobaoIntegrationImpl;
import com.bxm.adscounter.integration.taobao.TaobaoProperties;
import com.bxm.adscounter.integration.yoqu.YoquIntegration;
import com.bxm.adscounter.integration.yoqu.YoquIntegrationImpl;
import com.bxm.adscounter.integration.yoqu.YoquProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={YoquProperties.class, TaobaoProperties.class, MeituanProperties.class, DidiProperties.class, TaobaoProperties.class})
public class IntegrationAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(IntegrationAutoConfiguration.class);

    @Bean
    public DidiIntegration didiIntegration(DidiProperties didiProperties) {
        return new DidiIntegrationImpl(didiProperties);
    }

    @Bean
    public MeituanIntegration meituanIntegration(MeituanProperties meituanProperties) {
        return new MeituanIntegrationImpl(meituanProperties);
    }

    @Bean
    public TaobaoIntegration taobaoIntegration(TaobaoProperties taobaoProperties) {
        return new TaobaoIntegrationImpl(taobaoProperties);
    }

    @Bean
    public YoquIntegration yoquIntegration(YoquProperties yoquProperties) {
        try {
            return new YoquIntegrationImpl(yoquProperties);
        }
        catch (Exception e) {
            log.error("YoquIntegration Instantiate error", (Throwable)e);
            return null;
        }
    }
}

