/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration.didi;

import com.bxm.adscounter.integration.didi.DidiIntegration;
import com.bxm.adscounter.integration.didi.DidiProperties;
import com.bxm.adscounter.integration.didi.DidiRequest;
import com.bxm.adscounter.integration.didi.DidiResponse;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class DidiIntegrationImpl
implements DidiIntegration {
    private static final Logger log = LoggerFactory.getLogger(DidiIntegrationImpl.class);
    private final HttpClient httpClient;
    private final DidiProperties properties;

    public DidiIntegrationImpl(DidiProperties properties) {
        this.properties = properties;
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    @Override
    public boolean report(DidiRequest request) {
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        request.getParameters().forEach((arg_0, arg_1) -> this.lambda$report$0((MultiValueMap)param, arg_0, arg_1));
        String requestId = RandomStringUtils.randomAlphanumeric((int)8);
        this.put((MultiValueMap<String, String>)param, "request_id", requestId);
        String url = UriComponentsBuilder.fromUriString((String)this.properties.getReportClickUrl()).replaceQueryParams((MultiValueMap)param).build().toString();
        try {
            if (log.isInfoEnabled()) {
                log.info("{} - didi reporting: {}", (Object)requestId, (Object)url);
            }
            HttpGet get = new HttpGet(url);
            HttpResponse res = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            if (log.isInfoEnabled()) {
                log.info("{} - response: {}", (Object)requestId, (Object)body);
            }
            return ((DidiResponse)JsonHelper.convert((String)body, DidiResponse.class)).isSuccess();
        }
        catch (Exception e) {
            log.error("{} - didi report occur exception: {}", (Object)requestId, (Object)e.getMessage());
            return false;
        }
    }

    private void put(MultiValueMap<String, String> param, String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            param.add((Object)name, (Object)value);
        }
    }

    private /* synthetic */ void lambda$report$0(MultiValueMap param, String key, String value) {
        this.put((MultiValueMap<String, String>)param, key, value);
    }
}

