/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration.meituan;

import com.bxm.adscounter.integration.meituan.MeituanFeedback;
import com.bxm.adscounter.integration.meituan.MeituanIntegration;
import com.bxm.adscounter.integration.meituan.MeituanProperties;
import com.bxm.adscounter.integration.meituan.MeituanRequest;
import com.bxm.adscounter.integration.meituan.MeituanResponse;
import com.bxm.warcar.utils.JsonHelper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class MeituanIntegrationImpl
implements MeituanIntegration {
    private static final Logger log = LoggerFactory.getLogger(MeituanIntegrationImpl.class);
    private final HttpClient httpClient;

    public MeituanIntegrationImpl(MeituanProperties meituanProperties) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).setMaxConnPerRoute(meituanProperties.getHttpConcurrentRequest().intValue()).setMaxConnTotal(meituanProperties.getHttpConcurrentRequest().intValue()).build();
    }

    @Override
    public boolean report(MeituanRequest request) {
        return this.report(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean report(MeituanRequest request, MeituanFeedback feedback) {
        String reqId = RandomStringUtils.randomAlphanumeric((int)8);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        this.put((MultiValueMap<String, String>)param, "source", request.getSource());
        this.put((MultiValueMap<String, String>)param, "app_type", StringUtils.lowerCase((String)request.getAppType()));
        this.put((MultiValueMap<String, String>)param, "md5_imei", request.getImeiMd5());
        this.put((MultiValueMap<String, String>)param, "md5_idfa", request.getIdfaMd5());
        this.put((MultiValueMap<String, String>)param, "md5_oaid", request.getOaidMd5());
        this.put((MultiValueMap<String, String>)param, "oaid", request.getOaid());
        this.put((MultiValueMap<String, String>)param, "feedback_url", request.getFeedbackUrl());
        Map<String, String> extend = request.getExtend();
        if (MapUtils.isNotEmpty(extend)) {
            extend.forEach((arg_0, arg_1) -> this.lambda$report$0((MultiValueMap)param, arg_0, arg_1));
        }
        String url = UriComponentsBuilder.fromUriString((String)request.getReportUrl()).replaceQueryParams((MultiValueMap)param).build().toString();
        HttpGet httpGet = null;
        HttpResponse response = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Meituan: {} request {}", (Object)reqId, (Object)url);
            }
            httpGet = new HttpGet(url);
            response = this.httpClient.execute((HttpUriRequest)httpGet);
            String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (log.isDebugEnabled()) {
                log.debug("Meituan: {} response {}", (Object)reqId, (Object)body);
            }
            MeituanResponse res = (MeituanResponse)JsonHelper.convert((String)body, MeituanResponse.class);
            if (Objects.nonNull(feedback)) {
                feedback.call(request, res, url, null);
            }
            boolean bl = res.isSuccess();
            return bl;
        }
        catch (Exception e) {
            log.warn("Meituan: {} {}", (Object)reqId, (Object)e.getMessage());
            if (Objects.nonNull(feedback)) {
                feedback.call(request, null, url, e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
    }

    private void put(MultiValueMap<String, String> param, String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            param.add((Object)name, (Object)value);
        }
    }

    private /* synthetic */ void lambda$report$0(MultiValueMap param, String key, String value) {
        this.put((MultiValueMap<String, String>)param, key, value);
    }
}

