/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;

public abstract class CryptoUtil {
    public static byte[] digitalSign(byte[] plainBytes, PrivateKey privateKey, String signAlgorithm) throws Exception {
        try {
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initSign(privateKey);
            signature.update(plainBytes);
            byte[] signBytes = signature.sign();
            return signBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(String.format("\u751f\u6210\u5bc6\u94a5\u5de5\u5382\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", signAlgorithm));
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u6570\u5b57\u7b7e\u540d\u65f6\u79c1\u94a5\u65e0\u6548");
        }
        catch (SignatureException e) {
            throw new Exception("\u6570\u5b57\u7b7e\u540d\u65f6\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static boolean verifyDigitalSign(byte[] plainBytes, byte[] signBytes, PublicKey publicKey, String signAlgorithm) throws Exception {
        boolean isValid = false;
        try {
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initVerify(publicKey);
            signature.update(plainBytes);
            isValid = signature.verify(signBytes);
            return isValid;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(String.format("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", signAlgorithm));
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u65f6\u516c\u94a5\u65e0\u6548");
        }
        catch (SignatureException e) {
            throw new Exception("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u65f6\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static boolean verifyDigitalSign(byte[] plainBytes, byte[] signBytes, X509Certificate cert, String signAlgorithm) throws Exception {
        boolean isValid = false;
        try {
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initVerify(cert);
            signature.update(plainBytes);
            isValid = signature.verify(signBytes);
            return isValid;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new Exception(String.format("\u751f\u6210\u5bc6\u94a5\u5de5\u5382\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", signAlgorithm));
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new Exception("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u65f6\u516c\u94a5\u65e0\u6548");
        }
        catch (SignatureException e) {
            e.printStackTrace();
            throw new Exception("\u9a8c\u8bc1\u6570\u5b57\u7b7e\u540d\u65f6\u51fa\u73b0\u5f02\u5e38");
        }
    }

    public static PublicKey getPEMRSAPublicKeyByString(String publicOuterKey) throws Exception {
        X509EncodedKeySpec pubX509 = new X509EncodedKeySpec(Base64.decodeBase64((String)publicOuterKey));
        KeyFactory keyFactory = null;
        PublicKey pubKey = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            pubKey = keyFactory.generatePublic(pubX509);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u751f\u6210\u516c\u94a5\u65f6\u51fa\u73b0\u5f02\u5e38");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u751f\u6210\u516c\u94a5\u65f6\u65f6\u51fa\u73b0\u5f02\u5e38");
        }
        return pubKey;
    }

    public static PublicKey getRSAPublicKeyByFileSuffix(String filePath, String fileSuffix, String keyAlgorithm) throws Exception {
        FileInputStream in = null;
        String keyType = "";
        keyType = "crt".equalsIgnoreCase(fileSuffix) || "txt".equalsIgnoreCase(fileSuffix) || "cer".equalsIgnoreCase(fileSuffix) ? "X.509" : ("pem".equalsIgnoreCase(fileSuffix) ? "PKCS12" : ("yljf".equalsIgnoreCase(fileSuffix) ? "yljf" : "PKCS12"));
        try {
            in = new FileInputStream(filePath);
            PublicKey pubKey = null;
            if ("X.509".equals(keyType)) {
                CertificateFactory factory = CertificateFactory.getInstance(keyType);
                Certificate cert = factory.generateCertificate(in);
                pubKey = cert.getPublicKey();
            } else if ("PKCS12".equals(keyType)) {
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                StringBuilder sb = new StringBuilder();
                String readLine = null;
                while ((readLine = br.readLine()) != null) {
                    if (readLine.charAt(0) == '-') continue;
                    sb.append(readLine);
                    sb.append('\r');
                }
                X509EncodedKeySpec pubX509 = new X509EncodedKeySpec(Base64.decodeBase64((String)sb.toString()));
                KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
                pubKey = keyFactory.generatePublic(pubX509);
            } else if ("yljf".equals(keyType)) {
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "utf-8"));
                String s = br.readLine();
                ASN1InputStream ain = new ASN1InputStream(CryptoUtil.hexString2ByteArr(s));
                RSAPublicKeyStructure pStruct = RSAPublicKeyStructure.getInstance((Object)ain.readObject());
                RSAPublicKeySpec spec = new RSAPublicKeySpec(pStruct.getModulus(), pStruct.getPublicExponent());
                KeyFactory kf = KeyFactory.getInstance("RSA");
                if (in != null) {
                    ((InputStream)in).close();
                }
                PublicKey publicKey = kf.generatePublic(spec);
                return publicKey;
            }
            PublicKey publicKey = pubKey;
            return publicKey;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Exception("\u516c\u94a5\u8def\u5f84\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (CertificateException e) {
            e.printStackTrace();
            throw new Exception("\u751f\u6210\u8bc1\u4e66\u6587\u4ef6\u9519\u8bef");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("\u8bfb\u53d6\u516c\u94a5\u5f02\u5e38");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new Exception(String.format("\u751f\u6210\u5bc6\u94a5\u5de5\u5382\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", keyAlgorithm));
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
            throw new Exception("\u751f\u6210\u516c\u94a5\u5bf9\u8c61\u5f02\u5e38");
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static PrivateKey getPEMRSAPrivateKeyByString(String privateInnerKey) throws Exception {
        PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateInnerKey));
        KeyFactory keyFactory = null;
        PrivateKey priKey = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
            priKey = keyFactory.generatePrivate(priPKCS8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u751f\u6210\u79c1\u94a5\u5bf9\u8c61\u5f02\u5e38");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u751f\u6210\u79c1\u94a5\u5bf9\u8c61\u5f02\u5e38");
        }
        return priKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey getRSAPrivateKeyByFileSuffix(String filePath, String fileSuffix, String password, String keyAlgorithm) throws Exception {
        String keyType = "";
        keyType = "keystore".equalsIgnoreCase(fileSuffix) ? "JKS" : ("pfx".equalsIgnoreCase(fileSuffix) || "p12".equalsIgnoreCase(fileSuffix) ? "PKCS12" : ("jck".equalsIgnoreCase(fileSuffix) ? "JCEKS" : ("pem".equalsIgnoreCase(fileSuffix) || "pkcs8".equalsIgnoreCase(fileSuffix) ? "PKCS8" : ("pkcs1".equalsIgnoreCase(fileSuffix) ? "PKCS1" : ("yljf".equalsIgnoreCase(fileSuffix) ? "yljf" : ("ldys".equalsIgnoreCase(fileSuffix) ? "ldys" : "JKS"))))));
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            PrivateKey priKey = null;
            if ("JKS".equals(keyType) || "PKCS12".equals(keyType) || "JCEKS".equals(keyType)) {
                KeyStore ks = KeyStore.getInstance(keyType);
                if (password != null) {
                    char[] cPasswd = password.toCharArray();
                    ks.load(in, cPasswd);
                    Enumeration<String> aliasenum = ks.aliases();
                    String keyAlias = null;
                    while (aliasenum.hasMoreElements() && (priKey = (PrivateKey)ks.getKey(keyAlias = aliasenum.nextElement(), cPasswd)) == null) {
                    }
                }
            } else {
                if ("yljf".equals(keyType)) {
                    PrivateKey myprikey2;
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    String s = br.readLine();
                    PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(CryptoUtil.hexStrToBytes(s));
                    KeyFactory keyf = KeyFactory.getInstance("RSA");
                    PrivateKey privateKey = myprikey2 = keyf.generatePrivate(priPKCS8);
                    return privateKey;
                }
                if ("ldys".equals(keyType)) {
                    PrivateKey myprikey;
                    byte[] b = new byte[20480];
                    ((InputStream)in).read(b);
                    PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(b);
                    KeyFactory keyf = KeyFactory.getInstance("RSA");
                    PrivateKey myprikey2 = myprikey = keyf.generatePrivate(priPKCS8);
                    return myprikey2;
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                StringBuilder sb = new StringBuilder();
                String readLine = null;
                while ((readLine = br.readLine()) != null) {
                    if (readLine.charAt(0) == '-') continue;
                    sb.append(readLine);
                    sb.append('\r');
                }
                if ("PKCS8".equals(keyType)) {
                    PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)sb.toString()));
                    KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
                    priKey = keyFactory.generatePrivate(priPKCS8);
                } else if ("PKCS1".equals(keyType)) {
                    RSAPrivateKeyStructure asn1PrivKey = new RSAPrivateKeyStructure((ASN1Sequence)ASN1Sequence.fromByteArray((byte[])Base64.decodeBase64((String)sb.toString())));
                    RSAPrivateKeySpec rsaPrivKeySpec = new RSAPrivateKeySpec(asn1PrivKey.getModulus(), asn1PrivKey.getPrivateExponent());
                    KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
                    priKey = keyFactory.generatePrivate(rsaPrivKeySpec);
                }
            }
            PrivateKey privateKey = priKey;
            return privateKey;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new Exception("\u79c1\u94a5\u8def\u5f84\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (KeyStoreException e) {
            throw new Exception("\u83b7\u53d6KeyStore\u5bf9\u8c61\u5f02\u5e38");
        }
        catch (IOException e) {
            throw new Exception("\u8bfb\u53d6\u79c1\u94a5\u5f02\u5e38");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u751f\u6210\u79c1\u94a5\u5bf9\u8c61\u5f02\u5e38");
        }
        catch (CertificateException e) {
            throw new Exception("\u52a0\u8f7d\u79c1\u94a5\u5bc6\u7801\u5f02\u5e38");
        }
        catch (UnrecoverableKeyException e) {
            throw new Exception("\u751f\u6210\u79c1\u94a5\u5bf9\u8c61\u5f02\u5e38");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u751f\u6210\u79c1\u94a5\u5bf9\u8c61\u5f02\u5e38");
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] RSAEncrypt(byte[] plainBytes, PublicKey publicKey, int keyLength, int reserveSize, String cipherAlgorithm) throws Exception {
        int keyByteSize = keyLength / 8;
        int encryptBlockSize = keyByteSize - reserveSize;
        int nBlock = plainBytes.length / encryptBlockSize;
        if (plainBytes.length % encryptBlockSize != 0) {
            ++nBlock;
        }
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(1, publicKey);
            ByteArrayOutputStream outbuf = new ByteArrayOutputStream(nBlock * keyByteSize);
            for (int offset = 0; offset < plainBytes.length; offset += encryptBlockSize) {
                int inputLen = plainBytes.length - offset;
                if (inputLen > encryptBlockSize) {
                    inputLen = encryptBlockSize;
                }
                byte[] encryptedBlock = cipher.doFinal(plainBytes, offset, inputLen);
                outbuf.write(encryptedBlock);
            }
            outbuf.flush();
            outbuf.close();
            return outbuf.toByteArray();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new Exception(String.format("\u751f\u6210\u5bc6\u94a5\u5de5\u5382\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new Exception(String.format("\u751f\u6210\u5bc6\u94a5\u5de5\u5382\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", cipherAlgorithm));
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u65e0\u6548\u5bc6\u94a5");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u52a0\u5bc6\u5757\u5927\u5c0f\u4e0d\u5408\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new Exception("\u9519\u8bef\u586b\u5145\u6a21\u5f0f");
        }
        catch (IOException e) {
            throw new Exception("\u5b57\u8282\u8f93\u51fa\u6d41\u5f02\u5e38");
        }
    }

    public static byte[] RSADecrypt(byte[] encryptedBytes, PrivateKey privateKey, int keyLength, int reserveSize, String cipherAlgorithm) throws Exception {
        int keyByteSize = keyLength / 8;
        int decryptBlockSize = keyByteSize - reserveSize;
        int nBlock = encryptedBytes.length / keyByteSize;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            cipher.init(2, privateKey);
            ByteArrayOutputStream outbuf = new ByteArrayOutputStream(nBlock * decryptBlockSize);
            for (int offset = 0; offset < encryptedBytes.length; offset += keyByteSize) {
                int inputLen = encryptedBytes.length - offset;
                if (inputLen > keyByteSize) {
                    inputLen = keyByteSize;
                }
                byte[] decryptedBlock = cipher.doFinal(encryptedBytes, offset, inputLen);
                outbuf.write(decryptedBlock);
            }
            outbuf.flush();
            outbuf.close();
            return outbuf.toByteArray();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(String.format("\u6ca1\u6709[%s]\u6b64\u7c7b\u89e3\u5bc6\u7b97\u6cd5", cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new Exception(String.format("\u6ca1\u6709[%s]\u6b64\u7c7b\u586b\u5145\u6a21\u5f0f", cipherAlgorithm));
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u65e0\u6548\u5bc6\u94a5");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u89e3\u5bc6\u5757\u5927\u5c0f\u4e0d\u5408\u6cd5");
        }
        catch (BadPaddingException e) {
            throw new Exception("\u9519\u8bef\u586b\u5145\u6a21\u5f0f");
        }
        catch (IOException e) {
            throw new Exception("\u5b57\u8282\u8f93\u51fa\u6d41\u5f02\u5e38");
        }
    }

    public static byte[] AESEncrypt(byte[] plainBytes, byte[] keyBytes, String keyAlgorithm, String cipherAlgorithm, String IV) throws Exception {
        try {
            if (keyBytes.length % 8 != 0 || keyBytes.length < 16 || keyBytes.length > 32) {
                throw new Exception("AES\u5bc6\u94a5\u957f\u5ea6\u4e0d\u5408\u6cd5");
            }
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, keyAlgorithm);
            if (StringUtils.trimToNull((String)IV) != null) {
                IvParameterSpec ivspec = new IvParameterSpec(IV.getBytes());
                cipher.init(1, (Key)secretKey, ivspec);
            } else {
                cipher.init(1, secretKey);
            }
            byte[] encryptedBytes = cipher.doFinal(plainBytes);
            return encryptedBytes;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new Exception(String.format("\u751f\u6210\u5bc6\u94a5\u5de5\u5382\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new Exception(String.format("\u751f\u6210\u5bc6\u94a5\u5de5\u5382\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", cipherAlgorithm));
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new Exception("\u65e0\u6548\u5bc6\u94a5");
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            throw new Exception("\u65e0\u6548\u5bc6\u94a5\u53c2\u6570");
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new Exception("\u9519\u8bef\u586b\u5145\u6a21\u5f0f");
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new Exception("\u52a0\u5bc6\u5757\u5927\u5c0f\u4e0d\u5408\u6cd5");
        }
    }

    public static byte[] AESDecrypt(byte[] encryptedBytes, byte[] keyBytes, String keyAlgorithm, String cipherAlgorithm, String IV) throws Exception {
        try {
            if (keyBytes.length % 8 != 0 || keyBytes.length < 16 || keyBytes.length > 32) {
                throw new Exception("AES\u5bc6\u94a5\u957f\u5ea6\u4e0d\u5408\u6cd5");
            }
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, keyAlgorithm);
            if (IV != null && StringUtils.trimToNull((String)IV) != null) {
                IvParameterSpec ivspec = new IvParameterSpec(IV.getBytes());
                cipher.init(2, (Key)secretKey, ivspec);
            } else {
                cipher.init(2, secretKey);
            }
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return decryptedBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception(String.format("\u751f\u6210\u5bc6\u94a5\u5de5\u5382\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", cipherAlgorithm));
        }
        catch (NoSuchPaddingException e) {
            throw new Exception(String.format("\u751f\u6210\u5bc6\u94a5\u5de5\u5382\u65f6\u6ca1\u6709[%s]\u6b64\u7c7b\u7b97\u6cd5", cipherAlgorithm));
        }
        catch (InvalidKeyException e) {
            throw new Exception("\u65e0\u6548\u5bc6\u94a5");
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Exception("\u65e0\u6548\u5bc6\u94a5\u53c2\u6570");
        }
        catch (BadPaddingException e) {
            throw new Exception("\u9519\u8bef\u586b\u5145\u6a21\u5f0f");
        }
        catch (IllegalBlockSizeException e) {
            throw new Exception("\u89e3\u5bc6\u5757\u5927\u5c0f\u4e0d\u5408\u6cd5");
        }
    }

    public static byte[] hexString2ByteArr(String hexStr) {
        return new BigInteger(hexStr, 16).toByteArray();
    }

    public static final byte[] hexStrToBytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static String bytes2string(byte[] bytes, int radix) {
        int size = 2;
        if (radix == 2) {
            size = 8;
        }
        StringBuilder sb = new StringBuilder(bytes.length * size);
        for (int i = 0; i < bytes.length; ++i) {
            int integer;
            for (integer = bytes[i]; integer < 0; integer += 256) {
            }
            String str = Integer.toString(integer, radix);
            sb.append(StringUtils.leftPad((String)str.toUpperCase(), (int)size, (String)"0"));
        }
        return sb.toString();
    }

    public static String sha1(String data) {
        return DigestUtils.sha1Hex((String)data);
    }
}

