/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.integration.yoqu;

import com.bxm.adscounter.integration.utils.HttpClientUtils;
import com.bxm.adscounter.integration.yoqu.YoquIntegration;
import com.bxm.adscounter.integration.yoqu.YoquProperties;
import com.bxm.adscounter.integration.yoqu.YoquRequest;
import com.bxm.adscounter.integration.yoqu.YoquResponse;
import com.bxm.warcar.utils.JsonHelper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class YoquIntegrationImpl
implements YoquIntegration {
    private static final Logger log = LoggerFactory.getLogger(YoquIntegrationImpl.class);
    private final YoquProperties properties;
    private final HttpClient httpClient;

    public YoquIntegrationImpl(YoquProperties properties) throws KeyManagementException, NoSuchAlgorithmException {
        this.properties = properties;
        int maxTotal = 100;
        int defaultMaxPerRoute = 200;
        int connectionRequestTimeout = 1000;
        int connectTimeout = 1000;
        int socketTimeout = 2000;
        SSLContext sslContext = SSLContexts.custom().setProtocol("TLSv1.2").build();
        this.httpClient = HttpClientUtils.createHttpClient(maxTotal, defaultMaxPerRoute, connectionRequestTimeout, connectTimeout, socketTimeout, sslContext);
    }

    @Override
    public boolean report(YoquRequest request) {
        String reqId = RandomStringUtils.randomAlphanumeric((int)8);
        try {
            String url = this.properties.getUrl();
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            this.put((MultiValueMap<String, String>)params, "adAgent", request.getAdAgent());
            this.put((MultiValueMap<String, String>)params, "callbackUrl", request.getCallbackUrl());
            this.put((MultiValueMap<String, String>)params, "chainCode", request.getChainCode());
            this.put((MultiValueMap<String, String>)params, "event_type", request.getEventType());
            this.put((MultiValueMap<String, String>)params, "channel", request.getChannel());
            this.put((MultiValueMap<String, String>)params, "adid", request.getAdid());
            this.put((MultiValueMap<String, String>)params, "advertisingSpaceId", request.getAdvertisingSpaceId());
            this.put((MultiValueMap<String, String>)params, "taskId", request.getTaskId());
            this.put((MultiValueMap<String, String>)params, "os", request.getOs());
            this.put((MultiValueMap<String, String>)params, "imei", request.getImei());
            this.put((MultiValueMap<String, String>)params, "imeiMd5", request.getImeiMd5());
            this.put((MultiValueMap<String, String>)params, "oaid", request.getOaid());
            this.put((MultiValueMap<String, String>)params, "oaidMd5", request.getOaidMd5());
            this.put((MultiValueMap<String, String>)params, "idfa", request.getIdfa());
            this.put((MultiValueMap<String, String>)params, "idfaMd5", request.getIdfaMd5());
            String finalUrl = UriComponentsBuilder.fromUriString((String)url).replaceQueryParams((MultiValueMap)params).build().toString();
            if (log.isInfoEnabled()) {
                log.info("Yoqu: {} request {}", (Object)reqId, (Object)finalUrl);
            }
            HttpGet get = new HttpGet(finalUrl);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (log.isInfoEnabled()) {
                log.info("Yoqu: {} response {}", (Object)reqId, (Object)body);
            }
            YoquResponse res = (YoquResponse)JsonHelper.convert((String)body, YoquResponse.class);
            return res.isSuccess();
        }
        catch (IOException e) {
            log.warn("Yoqu: {} {}", (Object)reqId, (Object)e.getMessage());
            return false;
        }
    }

    private void put(MultiValueMap<String, String> param, String name, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            param.add((Object)name, (Object)value);
        }
    }
}

