/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common;

import com.bxm.adscounter.rtb.common.DataFetcher;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.service.FeedbackService;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class RtbIntegrationFactory
implements BeanPostProcessor {
    private final Map<Rtb, RtbIntegration> mapping = Maps.newHashMap();
    private final Map<Rtb, DataFetcher> dataFetcherMap = Maps.newHashMap();
    private final Map<Rtb, FeedbackService> feedbackServiceMap = Maps.newHashMap();

    public RtbIntegration get(Rtb rtb) {
        return this.mapping.get((Object)rtb);
    }

    public DataFetcher getDataFetcher(Rtb rtb) {
        return this.dataFetcherMap.get((Object)rtb);
    }

    public FeedbackService getFeedbackService(Rtb rtb) {
        return this.feedbackServiceMap.get((Object)rtb);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object exists;
        if (bean instanceof RtbIntegration) {
            RtbIntegration integ = (RtbIntegration)bean;
            exists = this.mapping.put(integ.rtb(), integ);
            this.check(exists, integ, integ.rtb());
        }
        if (bean instanceof DataFetcher) {
            DataFetcher fetcher = (DataFetcher)bean;
            exists = this.dataFetcherMap.put(fetcher.rtb(), fetcher);
            this.check(exists, fetcher, fetcher.rtb());
        }
        if (bean instanceof FeedbackService) {
            FeedbackService feedbackService = (FeedbackService)bean;
            exists = this.feedbackServiceMap.put(feedbackService.getRtb(), feedbackService);
            this.check(exists, feedbackService, feedbackService.getRtb());
        }
        return bean;
    }

    private void check(Object exists, Object n, Rtb rtb) {
        if (Objects.nonNull(exists)) {
            throw new RuntimeException("Registering [" + (Object)((Object)rtb) + "] bean " + n + " but has been exists! " + exists);
        }
    }
}

