/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.aop;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.control.ticket.TicketRatioControl;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.JsonHelper;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import redis.clients.jedis.JedisPool;

@Aspect
public class ControlRtbIntegrationAspect
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(ControlRtbIntegrationAspect.class);
    private final RatioControlRtbIntegration ratioControlRtbIntegration;
    private final JedisPool jedisPool;
    private final TicketRatioControl ticketRatioControl;

    public ControlRtbIntegrationAspect(RatioControlRtbIntegration ratioControlRtbIntegration, JedisPool jedisPool, TicketRatioControl ticketRatioControl) {
        this.ratioControlRtbIntegration = ratioControlRtbIntegration;
        this.jedisPool = jedisPool;
        this.ticketRatioControl = ticketRatioControl;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Pointcut(value="this(com.bxm.adscounter.rtb.common.RtbIntegration) && execution(com.bxm.adscounter.rtb.common.feedback.FeedbackResponse doFeedback(com.bxm.adscounter.rtb.common.feedback.FeedbackRequest))")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target;
        if (log.isDebugEnabled()) {
            log.debug("execute: {}", this.getClass());
        }
        if (!((target = point.getThis()) instanceof RtbIntegration)) {
            return point.proceed();
        }
        Object[] args = point.getArgs();
        if (ArrayUtils.isEmpty((Object[])args)) {
            return point.proceed();
        }
        Object firstArg = args[0];
        if (!(firstArg instanceof FeedbackRequest)) {
            return point.proceed();
        }
        FeedbackRequest request = (FeedbackRequest)firstArg;
        RtbIntegration rtbIntegration = (RtbIntegration)target;
        PositionRtb config = request.getConfig();
        if (Objects.isNull(config)) {
            return point.proceed();
        }
        try {
            boolean onTicketRatioControl = this.ticketRatioControl.onControl(request, rtbIntegration);
            if (onTicketRatioControl) {
                return FeedbackResponse.ofSuccess();
            }
        }
        catch (Exception onTicketRatioControl) {
            // empty catch block
        }
        boolean controlled = false;
        try {
            if (config.isCvrOrDeductionControl()) {
                controlled = this.ratioControlRtbIntegration.onFeedbackControl(rtbIntegration, request);
            }
        }
        catch (Exception e) {
            log.error("Feedback control invoke occur exception! " + JsonHelper.convert((Object)request), (Throwable)e);
        }
        if (!controlled) {
            return point.proceed();
        }
        return FeedbackResponse.ofSuccess();
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }
}

