/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.aop.interceptor;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.aop.RtbFeedbackInterceptor;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Lists;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class RetryInterceptor
implements RtbFeedbackInterceptor,
DisposableBean,
MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(RetryInterceptor.class);
    private final RtbIntegrationFactory factory;
    private final BlockingQueue<Retry> queue;
    private final ScheduledThreadPoolExecutor timer;
    private final int maxRetryTimes;

    public RetryInterceptor(RtbIntegrationFactory factory, int delay, int capacity, int maxRetryTimes) {
        this.factory = factory;
        this.queue = new LinkedBlockingQueue<Retry>(capacity);
        this.maxRetryTimes = maxRetryTimes;
        this.timer = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("retry-scheduler"));
        this.timer.scheduleWithFixedDelay(() -> {
            try {
                ArrayList retries = Lists.newArrayList();
                int i = this.queue.drainTo(retries);
                if (i > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Wait for try size: {}", (Object)i);
                    }
                    for (Retry retry : retries) {
                        this.doRetry(retry);
                    }
                }
            }
            catch (Exception e) {
                log.error("scheduled: ", (Throwable)e);
            }
        }, delay, delay, TimeUnit.SECONDS);
    }

    public void bindTo(MeterRegistry registry) {
        registry.gauge("rtb.retry.queue.size", (Object)0, value -> this.queue.size());
    }

    public void destroy() {
        this.timer.shutdownNow();
    }

    private void doRetry(Retry retry) {
        RtbIntegration integration = retry.getIntegration();
        FeedbackRequest request = retry.getRequest();
        int times = request.getRetryTimes();
        if (times >= this.maxRetryTimes) {
            return;
        }
        try {
            request.incrementRetryTimes();
            RtbIntegration proxyInstance = this.getRtbIntegrationCglibProxyInstance(integration);
            proxyInstance.doFeedback(request, 9);
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }

    private RtbIntegration getRtbIntegrationCglibProxyInstance(RtbIntegration integration) {
        return this.factory.get(integration.rtb());
    }

    @Override
    public void doRequest(RtbIntegration integration, FeedbackRequest request) {
    }

    @Override
    public void doSuccess(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
    }

    @Override
    public void doFail(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
    }

    @Override
    public void doException(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, Throwable throwable) {
        if (!(throwable instanceof RtbIntegrationException)) {
            return;
        }
        RtbIntegrationException exception = (RtbIntegrationException)throwable;
        switch (exception.getFailType()) {
            case IoException: 
            case ResolveProtocolException: {
                if (this.queue.offer(new Retry(integration, request))) break;
                log.error("Oops!! The queue size full!");
                break;
            }
        }
    }

    private static class Retry {
        private RtbIntegration integration;
        private FeedbackRequest request;

        public RtbIntegration getIntegration() {
            return this.integration;
        }

        public FeedbackRequest getRequest() {
            return this.request;
        }

        public void setIntegration(RtbIntegration integration) {
            this.integration = integration;
        }

        public void setRequest(FeedbackRequest request) {
            this.request = request;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Retry)) {
                return false;
            }
            Retry other = (Retry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RtbIntegration this$integration = this.getIntegration();
            RtbIntegration other$integration = other.getIntegration();
            if (this$integration == null ? other$integration != null : !this$integration.equals(other$integration)) {
                return false;
            }
            FeedbackRequest this$request = this.getRequest();
            FeedbackRequest other$request = other.getRequest();
            return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Retry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RtbIntegration $integration = this.getIntegration();
            result = result * 59 + ($integration == null ? 43 : $integration.hashCode());
            FeedbackRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            return result;
        }

        public String toString() {
            return "RetryInterceptor.Retry(integration=" + this.getIntegration() + ", request=" + this.getRequest() + ")";
        }

        public Retry(RtbIntegration integration, FeedbackRequest request) {
            this.integration = integration;
            this.request = request;
        }
    }
}

