/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.aop.interceptor;

import com.alibaba.fastjson.JSON;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.aop.RtbFeedbackInterceptor;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.adscounter.rtb.common.service.AbstractFeedbackService;
import com.bxm.adscounter.rtb.common.utils.PositionRTBUtils;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtbConversionOpenLogInterceptor
implements RtbFeedbackInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RtbConversionOpenLogInterceptor.class);
    private final RtbProperties properties;
    private final OpenLogClient openLogClient;

    public RtbConversionOpenLogInterceptor(RtbProperties properties, OpenLogClient openLogClient) {
        this.properties = properties;
        this.openLogClient = openLogClient;
    }

    @Override
    public void doRequest(RtbIntegration integration, FeedbackRequest request) {
    }

    @Override
    public void doSuccess(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        this.sendOpenLog(integration, request, response, 1, null);
    }

    @Override
    public void doFail(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
        this.sendOpenLog(integration, request, response, 2, null);
    }

    @Override
    public void doException(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, Throwable throwable) {
        this.sendOpenLog(integration, request, response, 3, throwable);
    }

    private void sendOpenLog(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, int rtbSc, Throwable throwable) {
        KeyValueMap keyValueMap = request.getKeyValueMap();
        PositionRtb positionRtb = request.getConfig();
        KeyValueMap map = new KeyValueMap();
        String msg = "";
        if (Objects.nonNull(throwable)) {
            String name = "";
            if (throwable instanceof RtbIntegrationException) {
                RtbIntegrationException e = (RtbIntegrationException)throwable;
                name = e.getFailType().name();
            }
            msg = StringUtils.substring((String)(name + " - " + throwable.getMessage()), (int)0, (int)255);
        }
        map.put("p", Production.COMMON.getName());
        map.put("mt", Common.Mt.rtbConversion.original());
        map.put("bxmid", (String)keyValueMap.getFirst((Object)"bxmid"));
        map.put("type", (String)keyValueMap.getFirst((Object)"conversion_type"));
        map.put("uid", (String)keyValueMap.getFirst((Object)"uid"));
        map.put("time", (Object)System.currentTimeMillis());
        map.put("adid", (String)keyValueMap.getFirst((Object)"adid"));
        map.put("tagid", (String)keyValueMap.getFirst((Object)"tagid"));
        map.put("createid", (String)keyValueMap.getFirst((Object)"createid"));
        map.put("ip", (String)keyValueMap.getFirst((Object)"ip"));
        map.put("ua", (String)keyValueMap.getFirst((Object)"ua"));
        map.put("rtb_id", (Object)integration.rtb().getType());
        map.put("ad_group_id", request.getAdGroupId());
        map.put("rtb_status", (Object)rtbSc);
        map.putIfNotBlank("refer", request.getReferrer());
        map.putIfNotBlank("rtb_request_uri", request.getRequestUrl());
        map.putIfNotBlank("rtb_event_type", request.getEventType());
        map.putIfNotBlank("rtb_req_body", request.getRequestBody());
        map.putIfNotBlank("rtb_res_body", Optional.ofNullable(response).map(FeedbackResponse::getBody).orElse(""));
        map.putIfNotBlank("rtb_res_msg", msg);
        map.putIfNotBlank("imei_md5", (String)keyValueMap.getFirst((Object)"imei_md5"));
        map.putIfNotBlank("idfa_md5", (String)keyValueMap.getFirst((Object)"idfa_md5"));
        map.putIfNotBlank("androidid_md5", (String)keyValueMap.getFirst((Object)"androidid_md5"));
        map.putIfNotBlank("oaid", (String)keyValueMap.getFirst((Object)"oaid"));
        map.putIfNotBlank("oaid_md5", (String)keyValueMap.getFirst((Object)"oaid_md5"));
        map.putIfNotBlank("action_time", (String)keyValueMap.getFirst((Object)"time"));
        map.putIfNotBlank("action_type", (String)Optional.ofNullable(request.getActionType()).map(ActionType::getValue).orElse(null));
        map.putIfNotBlank("smart_conv_type", Optional.ofNullable(request.getSmartConvType()).map(SmartConvType::getValue).orElse(SmartConvType.NONE.getValue()));
        map.putIfNotBlank("rank_by_activity", AbstractFeedbackService.getAcquiredRankByActivity(keyValueMap));
        map.putIfNotBlank("retry_flag", request.getRetryTimes() > 0 ? "1" : "0");
        map.putIfNotBlank("retry_flag", request.getRetryTimes() > 0 ? "1" : "0");
        if (positionRtb != null) {
            map.put("feedback_mode", (Object)positionRtb.getFeedbackMode());
            map.put("summary_source_type", (Object)positionRtb.getSummarySourceType());
            map.putIfNotBlank("ext", this.buildRtbConvExt(positionRtb, request));
        }
        String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain(), true);
        if (log.isDebugEnabled()) {
            log.debug("rtb conv openlog: {}", (Object)openLogRequestUri);
        }
        this.openLogClient.asyncRequest(openLogRequestUri);
    }

    private String buildRtbConvExt(PositionRtb positionRtb, FeedbackRequest request) {
        if (positionRtb.isSummaryByIncome()) {
            PositionRtb.RatioControl ratioControl = PositionRTBUtils.getRatioControl(positionRtb, request.getAdGroupId());
            String controlDimension = Optional.ofNullable(ratioControl.getAdGroupId()).orElse("");
            Double controlRatio = Optional.ofNullable(ratioControl.getShallowRatio()).orElse(1.0);
            Integer rtbTargetCpa = positionRtb.getRtbTargetCpa();
            RtbConvExt rtbConvExt = new RtbConvExt().setControl_dimension(controlDimension).setControl_ratio(controlRatio).setRtb_target_cpa(rtbTargetCpa);
            return JSON.toJSONString((Object)rtbConvExt);
        }
        return null;
    }

    public static class RtbConvExt {
        private String control_dimension;
        private Double control_ratio;
        private Integer rtb_target_cpa;

        public String getControl_dimension() {
            return this.control_dimension;
        }

        public Double getControl_ratio() {
            return this.control_ratio;
        }

        public Integer getRtb_target_cpa() {
            return this.rtb_target_cpa;
        }

        public RtbConvExt setControl_dimension(String control_dimension) {
            this.control_dimension = control_dimension;
            return this;
        }

        public RtbConvExt setControl_ratio(Double control_ratio) {
            this.control_ratio = control_ratio;
            return this;
        }

        public RtbConvExt setRtb_target_cpa(Integer rtb_target_cpa) {
            this.rtb_target_cpa = rtb_target_cpa;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RtbConvExt)) {
                return false;
            }
            RtbConvExt other = (RtbConvExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$control_ratio = this.getControl_ratio();
            Double other$control_ratio = other.getControl_ratio();
            if (this$control_ratio == null ? other$control_ratio != null : !((Object)this$control_ratio).equals(other$control_ratio)) {
                return false;
            }
            Integer this$rtb_target_cpa = this.getRtb_target_cpa();
            Integer other$rtb_target_cpa = other.getRtb_target_cpa();
            if (this$rtb_target_cpa == null ? other$rtb_target_cpa != null : !((Object)this$rtb_target_cpa).equals(other$rtb_target_cpa)) {
                return false;
            }
            String this$control_dimension = this.getControl_dimension();
            String other$control_dimension = other.getControl_dimension();
            return !(this$control_dimension == null ? other$control_dimension != null : !this$control_dimension.equals(other$control_dimension));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RtbConvExt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $control_ratio = this.getControl_ratio();
            result = result * 59 + ($control_ratio == null ? 43 : ((Object)$control_ratio).hashCode());
            Integer $rtb_target_cpa = this.getRtb_target_cpa();
            result = result * 59 + ($rtb_target_cpa == null ? 43 : ((Object)$rtb_target_cpa).hashCode());
            String $control_dimension = this.getControl_dimension();
            result = result * 59 + ($control_dimension == null ? 43 : $control_dimension.hashCode());
            return result;
        }

        public String toString() {
            return "RtbConversionOpenLogInterceptor.RtbConvExt(control_dimension=" + this.getControl_dimension() + ", control_ratio=" + this.getControl_ratio() + ", rtb_target_cpa=" + this.getRtb_target_cpa() + ")";
        }
    }
}

