/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.aop.interceptor;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbRedisKeys;
import com.bxm.adscounter.rtb.common.aop.RtbFeedbackInterceptor;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.time.Duration;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class SaveAdGroupConvInterceptor
implements RtbFeedbackInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SaveAdGroupConvInterceptor.class);
    private static final int EXPIRE_TIME = Math.toIntExact(Duration.ofDays(7L).getSeconds());
    private final JedisPool jedisPool;

    public SaveAdGroupConvInterceptor(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public void doRequest(RtbIntegration integration, FeedbackRequest request) {
        this.saveAdGroupConv(request);
    }

    @Override
    public void doSuccess(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
    }

    @Override
    public void doFail(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
    }

    @Override
    public void doException(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, Throwable throwable) {
    }

    private void saveAdGroupConv(FeedbackRequest request) {
        String rtbExt;
        PositionRtb config = request.getConfig();
        if (Objects.isNull(config)) {
            return;
        }
        if (!(config.isBaidu() || config.isKuaishou() || Objects.equals(config.getSourceType(), 32))) {
            return;
        }
        String positionId = config.getPositionId();
        String adGroupId = request.getAdGroupId();
        if (StringUtils.isBlank((String)adGroupId) && StringUtils.isNotBlank((String)(rtbExt = (String)request.getKeyValueMap().getFirst((Object)"rtb_ext")))) {
            RtbExtObject rtbExtObj = (RtbExtObject)JsonHelper.convert((String)UrlHelper.urlDecode((String)rtbExt), RtbExtObject.class);
            adGroupId = rtbExtObj.getAd_group_id();
        }
        if (StringUtils.isNotBlank((String)adGroupId)) {
            this.addClickId(positionId, adGroupId);
        }
        if (log.isDebugEnabled()) {
            log.debug("save adgroup conv {} - {}", (Object)positionId, (Object)adGroupId);
        }
    }

    private void addClickId(String positionId, String clickId) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RtbRedisKeys.strAdGroupConv(positionId, clickId).generateKey();
            jedis.set(key, "");
            jedis.expire(key, EXPIRE_TIME);
        }
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public static class RtbExtObject {
        private String click_id;
        private String ad_group_id;

        public String getClick_id() {
            return this.click_id;
        }

        public String getAd_group_id() {
            return this.ad_group_id;
        }

        public void setClick_id(String click_id) {
            this.click_id = click_id;
        }

        public void setAd_group_id(String ad_group_id) {
            this.ad_group_id = ad_group_id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RtbExtObject)) {
                return false;
            }
            RtbExtObject other = (RtbExtObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$click_id = this.getClick_id();
            String other$click_id = other.getClick_id();
            if (this$click_id == null ? other$click_id != null : !this$click_id.equals(other$click_id)) {
                return false;
            }
            String this$ad_group_id = this.getAd_group_id();
            String other$ad_group_id = other.getAd_group_id();
            return !(this$ad_group_id == null ? other$ad_group_id != null : !this$ad_group_id.equals(other$ad_group_id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RtbExtObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $click_id = this.getClick_id();
            result = result * 59 + ($click_id == null ? 43 : $click_id.hashCode());
            String $ad_group_id = this.getAd_group_id();
            result = result * 59 + ($ad_group_id == null ? 43 : $ad_group_id.hashCode());
            return result;
        }

        public String toString() {
            return "SaveAdGroupConvInterceptor.RtbExtObject(click_id=" + this.getClick_id() + ", ad_group_id=" + this.getAd_group_id() + ")";
        }
    }
}

