/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.aop.interceptor;

import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.aop.RtbFeedbackInterceptor;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.FeedbackResponse;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.UrlHelper;
import java.time.Duration;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class SaveClickIdInterceptor
implements RtbFeedbackInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SaveClickIdInterceptor.class);
    private static final int EXPIRE_TIME = Math.toIntExact(Duration.ofDays(7L).getSeconds());
    private final JedisPool jedisPool;

    public SaveClickIdInterceptor(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public void doRequest(RtbIntegration integration, FeedbackRequest request) {
        this.saveClickId(request);
    }

    @Override
    public void doSuccess(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
    }

    @Override
    public void doFail(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response) {
    }

    @Override
    public void doException(RtbIntegration integration, FeedbackRequest request, FeedbackResponse response, Throwable throwable) {
    }

    private void saveClickId(FeedbackRequest request) {
        String rtbExt;
        PositionRtb config = request.getConfig();
        if (Objects.isNull(config)) {
            return;
        }
        String positionId = config.getPositionId();
        String clickId = request.getClickId();
        if (StringUtils.isBlank((String)clickId) && StringUtils.isNotBlank((String)(rtbExt = (String)request.getKeyValueMap().getFirst((Object)"rtb_ext")))) {
            RtbExtObject rtbExtObj = (RtbExtObject)JsonHelper.convert((String)UrlHelper.urlDecode((String)rtbExt), RtbExtObject.class);
            clickId = rtbExtObj.getClick_id();
        }
        if (StringUtils.isNotBlank((String)clickId)) {
            this.addClickId(positionId, clickId);
        }
    }

    private void addClickId(String positionId, String clickId) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = RedisKeyGenerator.strFeedbackClickId((String)positionId, (String)clickId).generateKey();
            jedis.set(RedisKeyGenerator.strFeedbackClickId((String)positionId, (String)clickId).generateKey(), "");
            jedis.expire(key, EXPIRE_TIME);
        }
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public static class RtbExtObject {
        private String click_id;

        public String getClick_id() {
            return this.click_id;
        }

        public void setClick_id(String click_id) {
            this.click_id = click_id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RtbExtObject)) {
                return false;
            }
            RtbExtObject other = (RtbExtObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$click_id = this.getClick_id();
            String other$click_id = other.getClick_id();
            return !(this$click_id == null ? other$click_id != null : !this$click_id.equals(other$click_id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RtbExtObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $click_id = this.getClick_id();
            result = result * 59 + ($click_id == null ? 43 : $click_id.hashCode());
            return result;
        }

        public String toString() {
            return "SaveClickIdInterceptor.RtbExtObject(click_id=" + this.getClick_id() + ")";
        }
    }
}

