/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.autoconfigure;

import com.bxm.adscounter.rtb.common.impl.baidu.BaiduConfig;
import com.bxm.adscounter.rtb.common.impl.baidu.BaiduDataFetcher;
import com.bxm.adscounter.rtb.common.impl.bxmtest.BxmTestDataFetcher;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouConfig;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouDataFetcher;
import com.bxm.warcar.cache.Fetcher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import redis.clients.jedis.JedisPool;

public class DataFetcherAutoConfigration {
    private final JedisPool jedisPool;
    private final Fetcher fetcher;

    public DataFetcherAutoConfigration(@Qualifier(value="rtbJedisPool") JedisPool jedisPool, Fetcher fetcher) {
        this.jedisPool = jedisPool;
        this.fetcher = fetcher;
    }

    @Bean
    public KuaishouDataFetcher kuaishouDataFetcher(KuaishouConfig config) {
        return new KuaishouDataFetcher(config, this.jedisPool, this.fetcher);
    }

    @Bean
    public BaiduDataFetcher baiduDataFetcher(BaiduConfig config) {
        return new BaiduDataFetcher(config, this.jedisPool, this.fetcher);
    }

    @Bean
    public BxmTestDataFetcher bxmDataFetcher() {
        return new BxmTestDataFetcher(this.fetcher);
    }
}

