/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.control.ControlUtils;
import com.bxm.adscounter.rtb.common.control.LocalDateTimeUtils;
import com.bxm.adscounter.rtb.common.control.PlusControlRtbIntegration;
import com.bxm.adscounter.rtb.common.control.plus.PlusControl;
import com.bxm.adscounter.rtb.common.control.plus.PlusControlConfig;
import com.bxm.adscounter.rtb.common.control.plus.PlusQueueService;
import com.bxm.adscounter.rtb.common.control.plus.RedisPlusControlImpl;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.mapper.SrcAdUserAccessLogMapper;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.SafeMapHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.zk.ZkClientHolder;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import redis.clients.jedis.JedisPool;

@Deprecated
public abstract class AbstractPlusControlRtbIntegration
implements PlusControlRtbIntegration,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractPlusControlRtbIntegration.class);
    private final ScheduledThreadPoolExecutor refreshExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("refresh"));
    private final ConcurrentHashMap<String, PlusControl> controlExecutors = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Set<String>> mapping = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> referenced = new ConcurrentHashMap();
    private final JedisPool jedisPool;
    private final PositionRtbService service;
    private final EventPark eventPark;
    private final SrcAdUserAccessLogMapper srcAdUserAccessLogMapper;
    private final PlusQueueService plusQueueService;
    private MeterRegistry registry;
    private ZkClientHolder zkClientHolder;
    private RtbIntegrationFactory rtbIntegrationFactory;

    public AbstractPlusControlRtbIntegration(JedisPool jedisPool, PositionRtbService service, EventPark eventPark, RtbIntegrationFactory rtbIntegrationFactory, SrcAdUserAccessLogMapper srcAdUserAccessLogMapper, PlusQueueService plusQueueService) {
        this.jedisPool = jedisPool;
        this.service = service;
        this.eventPark = eventPark;
        this.srcAdUserAccessLogMapper = srcAdUserAccessLogMapper;
        this.rtbIntegrationFactory = rtbIntegrationFactory;
        this.plusQueueService = plusQueueService;
        this.refreshExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.refreshControlForMapping();
            }
            catch (Exception e) {
                log.error("occur ex: ", (Throwable)e);
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    @Autowired
    @Qualifier(value="rtbZkClientHolder")
    public void setZkClientHolder(ZkClientHolder zkClientHolder) {
        this.zkClientHolder = zkClientHolder;
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    public void destroy() {
        this.refreshExecutor.shutdownNow();
    }

    private List<PositionRtb.PlusControl> chooseControls(PositionRtb config) {
        return config.getPlusControls();
    }

    private void refreshControlForMapping() {
        if (log.isDebugEnabled()) {
            log.debug("Starting refresh Plus Controller...");
        }
        this.createForEnablePositions();
        final HashSet<String> alive = new HashSet<String>(this.referenced.values());
        this.mapping.forEach(new BiConsumer<Integer, Set<String>>(){

            @Override
            public void accept(Integer id, Set<String> keys) {
                keys.forEach(key -> {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Checking {}", (Object)id, key);
                    }
                    String tagId = ControlUtils.splitKey(key)[0];
                    PositionRtb config = AbstractPlusControlRtbIntegration.this.service.get(tagId);
                    if (Objects.isNull(config)) {
                        AbstractPlusControlRtbIntegration.this.close(id);
                        return;
                    }
                    List controls = config.getPlusControls();
                    if (CollectionUtils.isEmpty((Collection)controls)) {
                        AbstractPlusControlRtbIntegration.this.close(id);
                        return;
                    }
                    if (!alive.contains(key)) {
                        AbstractPlusControlRtbIntegration.this.close(id);
                        return;
                    }
                    for (PositionRtb.PlusControl cfg : controls) {
                        if (!Objects.equals(id, cfg.getId())) continue;
                        if (!cfg.isEnable()) {
                            AbstractPlusControlRtbIntegration.this.close(id);
                            continue;
                        }
                        if (!AbstractPlusControlRtbIntegration.validDate(cfg.getDate())) {
                            AbstractPlusControlRtbIntegration.this.close(id);
                            continue;
                        }
                        AbstractPlusControlRtbIntegration.this.refresh(id, cfg, config);
                    }
                });
            }
        });
    }

    private void refresh(Integer id, PositionRtb.PlusControl cfg, PositionRtb positionRtb) {
        Set<String> executors = this.mapping.get(id);
        if (CollectionUtils.isNotEmpty(executors)) {
            executors.forEach(key -> {
                Integer limit;
                PlusControlConfig config;
                PlusControl control = this.controlExecutors.get(key);
                if (Objects.nonNull(control) && (config = control.getConfig()).isUpdate((limit = cfg.getLimit()).intValue())) {
                    config.setLimit(limit);
                    config.setPositionRtb(positionRtb);
                    control.refresh();
                    if (log.isInfoEnabled()) {
                        log.info("{} Update to: {}", key, (Object)config.toSimpleString());
                    }
                }
            });
        }
    }

    private void close(Integer id) {
        Set<String> executors = this.mapping.get(id);
        if (CollectionUtils.isNotEmpty(executors)) {
            executors.removeIf(new Predicate<String>(){

                @Override
                public boolean test(String key) {
                    PlusControl control = (PlusControl)AbstractPlusControlRtbIntegration.this.controlExecutors.get(key);
                    if (Objects.nonNull(control)) {
                        control.delete();
                        control.shutdown();
                    }
                    AbstractPlusControlRtbIntegration.this.controlExecutors.remove(key);
                    if (log.isInfoEnabled()) {
                        log.info("Close control: {} - {}", (Object)key, (Object)control);
                    }
                    return true;
                }
            });
        }
    }

    private void createForEnablePositions() {
        List enablePositionRtbs = this.service.getAll().stream().filter(p -> CollectionUtils.isNotEmpty((Collection)p.getPlusControls())).collect(Collectors.toList());
        for (PositionRtb config : enablePositionRtbs) {
            String tagId = config.getPositionId();
            List<PositionRtb.PlusControl> controls = this.chooseControls(config);
            if (!CollectionUtils.isNotEmpty(controls)) continue;
            for (PositionRtb.PlusControl cfg : controls) {
                if (!cfg.isEnable() || !AbstractPlusControlRtbIntegration.validDate(cfg.getDate())) continue;
                this.createIfNecessary(config.getSourceType(), tagId, cfg.getAdGroupId(), cfg, config);
            }
        }
    }

    private void createIfNecessary(final Integer sourceType, final String tagId, final String adGroupId, final PositionRtb.PlusControl hit, final PositionRtb config) {
        final String key = ControlUtils.createKey(tagId, adGroupId, TypeHelper.castToString((Object)hit.getId()));
        SafeMapHelper.get(this.controlExecutors, (Object)key, (SafeMapHelper.InitializingValue)new SafeMapHelper.InitializingValue<PlusControl>(){

            public PlusControl initializing() {
                Rtb rtb = Rtb.of(sourceType);
                final RtbIntegration instance = AbstractPlusControlRtbIntegration.this.rtbIntegrationFactory.get(rtb);
                String date = hit.getDate();
                String startTime = hit.getStartTime();
                String endTime = hit.getEndTime();
                PlusControlConfig plusControlConfig = new PlusControlConfig().setDimension(key).setControlId(hit.getId()).setDate(date).setStartTime(date + " " + startTime).setEndTime(date + " " + endTime).setLimit(hit.getLimit()).setN(hit.getN()).setY(hit.getY()).setPositionId(tagId).setAdGroupId(adGroupId).setPositionRtb(config).setConsumer(new Consumer<FeedbackRequest>(){

                    @Override
                    public void accept(FeedbackRequest request) {
                        AbstractPlusControlRtbIntegration.this.doFeedbackQuietly(instance, request);
                    }
                });
                RedisPlusControlImpl plusControl = new RedisPlusControlImpl(plusControlConfig, AbstractPlusControlRtbIntegration.this.jedisPool, AbstractPlusControlRtbIntegration.this.registry, AbstractPlusControlRtbIntegration.this.eventPark, AbstractPlusControlRtbIntegration.this.zkClientHolder, AbstractPlusControlRtbIntegration.this.srcAdUserAccessLogMapper, AbstractPlusControlRtbIntegration.this.plusQueueService);
                plusControl.start();
                ((Set)SafeMapHelper.get((Map)AbstractPlusControlRtbIntegration.this.mapping, (Object)hit.getId(), HashSet::new)).add(key);
                String referencedKey = tagId + adGroupId + hit.getId();
                String previous = AbstractPlusControlRtbIntegration.this.referenced.put(referencedKey, key);
                if (Objects.nonNull(previous)) {
                    log.info("Plus control {} reference changed to {}", (Object)previous, (Object)key);
                }
                return plusControl;
            }
        });
    }

    private void doFeedbackQuietly(RtbIntegration instance, FeedbackRequest request) {
        try {
            instance.doFeedback(request, 1);
        }
        catch (RtbIntegrationException e) {
            log.error("doFeedbackQuietly: ", (Throwable)e);
        }
    }

    private static boolean validDate(String date) {
        LocalDate localDate = LocalDateTimeUtils.parseDate(date);
        LocalDate sevenDayAgo = LocalDate.now().minusDays(7L);
        return localDate != null && localDate.isAfter(sevenDayAgo);
    }
}

