/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control;

import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.control.ControlUtils;
import com.bxm.adscounter.rtb.common.control.LocalDateTimeUtils;
import com.bxm.adscounter.rtb.common.control.RateControlRtbIntegration;
import com.bxm.adscounter.rtb.common.control.rate.RateControl;
import com.bxm.adscounter.rtb.common.control.rate.RateControlConfig;
import com.bxm.adscounter.rtb.common.control.rate.RedisRateControlImpl;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.mapper.SrcAdUserAccessLogMapper;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.SafeMapHelper;
import com.bxm.warcar.zk.ZkClientHolder;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import redis.clients.jedis.JedisPool;

@Deprecated
public abstract class AbstractRateControlRtbIntegration
implements RateControlRtbIntegration,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractRateControlRtbIntegration.class);
    private final ScheduledThreadPoolExecutor refreshExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("refresh"));
    private final ConcurrentHashMap<String, RateControl> controlExecutors = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Set<String>> mapping = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> referenced = new ConcurrentHashMap();
    private final JedisPool jedisPool;
    private final PositionRtbService service;
    private final EventPark eventPark;
    private final SrcAdUserAccessLogMapper srcAdUserAccessLogMapper;
    private MeterRegistry registry;
    private ZkClientHolder zkClientHolder;
    private RtbIntegrationFactory rtbIntegrationFactory;

    public AbstractRateControlRtbIntegration(JedisPool jedisPool, PositionRtbService service, EventPark eventPark, RtbIntegrationFactory rtbIntegrationFactory, SrcAdUserAccessLogMapper srcAdUserAccessLogMapper) {
        this.jedisPool = jedisPool;
        this.service = service;
        this.eventPark = eventPark;
        this.srcAdUserAccessLogMapper = srcAdUserAccessLogMapper;
        this.rtbIntegrationFactory = rtbIntegrationFactory;
        this.refreshExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.refreshControlForMapping();
            }
            catch (Exception e) {
                log.error("occur ex: ", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    @Autowired
    @Qualifier(value="rtbZkClientHolder")
    public void setZkClientHolder(ZkClientHolder zkClientHolder) {
        this.zkClientHolder = zkClientHolder;
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
    }

    public void destroy() {
        this.refreshExecutor.shutdownNow();
    }

    protected abstract List<PositionRtb.SpeedControl> chooseControls(PositionRtb var1);

    protected abstract String createControlKey(String var1, String var2, String var3, PositionRtb.SpeedControl var4);

    protected abstract String createReferencedKey(String var1, String var2, String var3, PositionRtb.SpeedControl var4);

    private void refreshControlForMapping() {
        if (log.isDebugEnabled()) {
            log.debug("Starting refresh Rate Controller...");
        }
        this.createForEnablePositions();
        final HashSet<String> alive = new HashSet<String>(this.referenced.values());
        this.mapping.forEach(new BiConsumer<Long, Set<String>>(){

            @Override
            public void accept(Long id, Set<String> keys) {
                keys.forEach(key -> {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Checking {}", (Object)id, key);
                    }
                    String tagId = ControlUtils.splitKey(key)[0];
                    PositionRtb config = AbstractRateControlRtbIntegration.this.service.get(tagId);
                    if (Objects.isNull(config)) {
                        AbstractRateControlRtbIntegration.this.close(id);
                        return;
                    }
                    List<PositionRtb.SpeedControl> controls = AbstractRateControlRtbIntegration.this.chooseControls(config);
                    if (CollectionUtils.isEmpty(controls)) {
                        AbstractRateControlRtbIntegration.this.close(id);
                        return;
                    }
                    if (!alive.contains(key)) {
                        AbstractRateControlRtbIntegration.this.close(id);
                        return;
                    }
                    for (PositionRtb.SpeedControl cfg : controls) {
                        if (!Objects.equals(id, cfg.getId())) continue;
                        if (!cfg.isEnable()) {
                            AbstractRateControlRtbIntegration.this.close(id);
                            continue;
                        }
                        boolean validTime = AbstractRateControlRtbIntegration.this.isValidTime(cfg.getDate(), cfg.getStartTime(), cfg.getEndTime());
                        if (!validTime) {
                            AbstractRateControlRtbIntegration.this.close(id);
                            continue;
                        }
                        AbstractRateControlRtbIntegration.this.refresh(id, cfg, config);
                    }
                });
            }
        });
    }

    private void refresh(Long id, PositionRtb.SpeedControl cfg, PositionRtb positionRtb) {
        Set<String> executors = this.mapping.get(id);
        if (CollectionUtils.isNotEmpty(executors)) {
            executors.forEach(key -> {
                RateControl control = this.controlExecutors.get(key);
                if (Objects.nonNull(control)) {
                    RateControlConfig config = control.getConfig();
                    Integer count = cfg.getCount();
                    LocalTime start = LocalDateTimeUtils.parseTime(cfg.getStartTime());
                    LocalTime end = LocalDateTimeUtils.parseTime(cfg.getEndTime());
                    if (config.isUpdate(count.intValue(), start, end)) {
                        config.setCount(count.intValue());
                        config.setStart(start);
                        config.setEnd(end);
                        config.setPositionRtb(positionRtb);
                        control.refresh();
                        if (log.isInfoEnabled()) {
                            log.info("{} Update to: {}", key, (Object)config.toSimpleString());
                        }
                    }
                }
            });
        }
    }

    private void close(Long id) {
        Set<String> executors = this.mapping.get(id);
        if (CollectionUtils.isNotEmpty(executors)) {
            executors.removeIf(new Predicate<String>(){

                @Override
                public boolean test(String key) {
                    RateControl control = (RateControl)AbstractRateControlRtbIntegration.this.controlExecutors.get(key);
                    if (Objects.nonNull(control)) {
                        control.delete();
                        control.shutdown();
                    }
                    AbstractRateControlRtbIntegration.this.controlExecutors.remove(key);
                    if (log.isInfoEnabled()) {
                        log.info("Close control: {} - {}", (Object)key, (Object)control);
                    }
                    return true;
                }
            });
        }
    }

    private void createForEnablePositions() {
        List enablePositionRtbs = this.service.getAll().stream().filter(p -> CollectionUtils.isNotEmpty((Collection)p.getTicketControls()) || CollectionUtils.isNotEmpty((Collection)p.getActivityControls())).collect(Collectors.toList());
        for (PositionRtb config : enablePositionRtbs) {
            String tagId = config.getPositionId();
            List<PositionRtb.SpeedControl> controls = this.chooseControls(config);
            if (!CollectionUtils.isNotEmpty(controls)) continue;
            for (PositionRtb.SpeedControl cfg : controls) {
                boolean validTime;
                if (!cfg.isEnable() || !(validTime = this.isValidTime(cfg.getDate(), cfg.getStartTime(), cfg.getEndTime()))) continue;
                this.createIfNecessary(config.getSourceType(), tagId, cfg.getAdTicketId(), cfg.getAdGroupId(), cfg, config);
            }
        }
    }

    private RateControl createIfNecessary(final Integer sourceType, final String tagId, final String adId, final String adGroupId, final PositionRtb.SpeedControl hit, final PositionRtb config) {
        final String key = this.createControlKey(tagId, adId, adGroupId, hit);
        return (RateControl)SafeMapHelper.get(this.controlExecutors, (Object)key, (SafeMapHelper.InitializingValue)new SafeMapHelper.InitializingValue<RateControl>(){

            public RateControl initializing() {
                Rtb rtb = Rtb.of(sourceType);
                final RtbIntegration instance = AbstractRateControlRtbIntegration.this.rtbIntegrationFactory.get(rtb);
                LocalTime start = LocalDateTimeUtils.parseTime(hit.getStartTime());
                LocalTime end = LocalDateTimeUtils.parseTime(hit.getEndTime());
                RateControlConfig rateControlConfig = new RateControlConfig().setDimension(key).setStart(start).setEnd(end).setCount(hit.getCount().intValue()).setPositionId(tagId).setAdGroupId(adGroupId).setPositionRtb(config).setActionType(AbstractRateControlRtbIntegration.this.getActionType(hit)).setAdId(hit.getAdTicketId()).setConsumer(new Consumer<FeedbackRequest>(){

                    @Override
                    public void accept(FeedbackRequest request) {
                        AbstractRateControlRtbIntegration.this.doFeedbackQuietly(instance, request);
                    }
                });
                RedisRateControlImpl rateControl = new RedisRateControlImpl(rateControlConfig, AbstractRateControlRtbIntegration.this.jedisPool, AbstractRateControlRtbIntegration.this.registry, AbstractRateControlRtbIntegration.this.eventPark, AbstractRateControlRtbIntegration.this.zkClientHolder, AbstractRateControlRtbIntegration.this.srcAdUserAccessLogMapper);
                rateControl.start();
                ((Set)SafeMapHelper.get((Map)AbstractRateControlRtbIntegration.this.mapping, (Object)hit.getId(), HashSet::new)).add(key);
                String referencedKey = AbstractRateControlRtbIntegration.this.createReferencedKey(tagId, adId, adGroupId, hit);
                String previous = AbstractRateControlRtbIntegration.this.referenced.put(referencedKey, key);
                if (Objects.nonNull(previous)) {
                    log.info("Rate control {} reference changed to {}", (Object)previous, (Object)key);
                }
                return rateControl;
            }
        });
    }

    protected boolean isValidTime(String date, String startTime, String endTime) {
        LocalDate d = LocalDateTimeUtils.parseDate(date);
        LocalTime start = LocalDateTimeUtils.parseTime(startTime);
        LocalTime end = LocalDateTimeUtils.parseTime(endTime);
        if (Objects.isNull(d) || Objects.isNull(start) || Objects.isNull(end)) {
            return false;
        }
        boolean isToday = LocalDate.now().isEqual(d);
        LocalTime now = LocalTime.now().withNano(0);
        boolean isValidTime = now.equals(start) || now.equals(end) || now.isAfter(start) && now.isBefore(end);
        return isToday && isValidTime;
    }

    protected abstract ActionType getActionType(PositionRtb.SpeedControl var1);

    private void doFeedbackQuietly(RtbIntegration instance, FeedbackRequest request) {
        try {
            instance.doFeedback(request, 1);
        }
        catch (RtbIntegrationException e) {
            log.error("doFeedbackQuietly: ", (Throwable)e);
        }
    }
}

