/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control;

import com.bxm.adscounter.rtb.common.ClickTracker;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.control.ControlUtils;
import com.bxm.adscounter.rtb.common.control.LocalDateTimeUtils;
import com.bxm.adscounter.rtb.common.control.RatioControlRtbIntegration;
import com.bxm.adscounter.rtb.common.control.cpa.CpaControl;
import com.bxm.adscounter.rtb.common.control.deduction.ConversionLevel;
import com.bxm.adscounter.rtb.common.control.plus.PlusQueueService;
import com.bxm.adscounter.rtb.common.control.ratio.ClickLog;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControl;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlBus;
import com.bxm.adscounter.rtb.common.control.ratio.RatioControlConfig;
import com.bxm.adscounter.rtb.common.control.ratio.RedisRatioControlImpl;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioAdClickEvent;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioClickEvent;
import com.bxm.adscounter.rtb.common.control.ratio.event.RatioConversionEvent;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adscounter.rtb.common.utils.PositionRTBUtils;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.bxm.warcar.utils.SafeMapHelper;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.zk.ZkClientHolder;
import com.google.common.collect.Sets;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.LocalTime;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class DefaultRatioControlRtbIntegrationImpl
implements RatioControlRtbIntegration,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultRatioControlRtbIntegrationImpl.class);
    private final ScheduledThreadPoolExecutor refreshExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("refresh"));
    private final ConcurrentHashMap<String, RatioControl> controlExecutors = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Set<String>> mapping = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> referenced = new ConcurrentHashMap();
    private final JedisPool jedisPool;
    private final PositionRtbService service;
    private final EventPark eventPark;
    private final CpaControl cpaControl;
    private final PlusQueueService plusQueueService;
    private MeterRegistry registry;
    private ZkClientHolder zkClientHolder;
    private RtbIntegrationFactory factory;

    public DefaultRatioControlRtbIntegrationImpl(JedisPool jedisPool, PositionRtbService service, EventPark eventPark, CpaControl cpaControl, PlusQueueService plusQueueService) {
        this.jedisPool = jedisPool;
        this.service = service;
        this.eventPark = eventPark;
        this.cpaControl = cpaControl;
        this.plusQueueService = plusQueueService;
        this.refreshExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.refreshControlForMapping();
            }
            catch (Exception e) {
                log.error("occur ex: ", (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    @Autowired
    @Qualifier(value="rtbZkClientHolder")
    public void setZkClientHolder(ZkClientHolder zkClientHolder) {
        this.zkClientHolder = zkClientHolder;
    }

    @Autowired
    public void setFactory(RtbIntegrationFactory factory) {
        this.factory = factory;
    }

    public void destroy() {
        this.refreshExecutor.shutdownNow();
        this.controlExecutors.values().forEach(e -> {
            e.delete();
            e.shutdown();
        });
    }

    public void bindTo(MeterRegistry registry) {
        this.registry = registry;
        this.registryMeter();
    }

    private void registryMeter() {
        this.registry.gauge("ratio.control.executors", (Object)0, (ToDoubleFunction)new ToDoubleFunction<Integer>(){

            @Override
            public double applyAsDouble(Integer value) {
                return DefaultRatioControlRtbIntegrationImpl.this.controlExecutors.size();
            }
        });
    }

    private boolean isHeadTicket(PositionRtb config, String adid) {
        return PositionRTBUtils.isHeadTicket(adid, config);
    }

    @Override
    public void onClick(RtbIntegration instance, KeyValueMap clickTrackerKeyValueMap, String adGroupId) {
        this.onClick(instance, clickTrackerKeyValueMap, adGroupId, null);
    }

    @Override
    public void onClick(RtbIntegration instance, KeyValueMap clickTrackerKeyValueMap, String adGroupId, String app) {
        app = StringUtils.defaultIfBlank((String)app, (String)"-");
        if (!(instance instanceof ClickTracker)) {
            return;
        }
        ClickTracker clickTracker = (ClickTracker)((Object)instance);
        if (StringUtils.isBlank((String)(adGroupId = clickTracker.fixAdGroupIdIfInvalid(adGroupId)))) {
            return;
        }
        String tagId = (String)clickTrackerKeyValueMap.getFirst((Object)"tagid");
        if (StringUtils.isBlank((String)tagId)) {
            log.warn("tagid is blank for {}!", (Object)adGroupId);
            return;
        }
        PositionRtb config = this.service.get(tagId);
        if (Objects.isNull(config)) {
            return;
        }
        PositionRtb.RatioControl hit = DefaultRatioControlRtbIntegrationImpl.chooseCvrControl(config, adGroupId);
        if (Objects.nonNull(hit)) {
            String clickId = clickTracker.getClickId(clickTrackerKeyValueMap);
            if (this.isRepeatClick(clickTracker, clickId)) {
                log.debug("Repeat click: {}", (Object)clickId);
                return;
            }
            RatioControl control = this.createIfNecessary(instance, tagId, adGroupId, hit, config);
            control.onClick(clickId, app);
            this.eventPark.post((EventObject)new RatioClickEvent(this, control, adGroupId, app));
        }
    }

    @Override
    public void onTicketClick(RtbIntegration instance, KeyValueMap clickTrackerKeyValueMap, KeyValueMap clickKeyValueMap, String adGroupId, String app) {
        app = StringUtils.defaultIfBlank((String)app, (String)"-");
        if (StringUtils.isBlank((String)adGroupId)) {
            return;
        }
        if (!(instance instanceof ClickTracker)) {
            return;
        }
        ClickTracker clickTracker = (ClickTracker)((Object)instance);
        String tagId = (String)clickKeyValueMap.getFirst((Object)"tagid");
        String adid = (String)clickKeyValueMap.getFirst((Object)"adid");
        if (StringUtils.isBlank((String)tagId)) {
            return;
        }
        PositionRtb config = this.service.get(tagId);
        if (Objects.isNull(config)) {
            return;
        }
        if (!config.isCvrOrDeductionControl()) {
            return;
        }
        PositionRtb.RatioControl hit = DefaultRatioControlRtbIntegrationImpl.chooseCvrControl(config, adGroupId);
        if (Objects.isNull(hit)) {
            return;
        }
        String clickId = clickTracker.getClickId(clickTrackerKeyValueMap);
        RatioControl control = this.createIfNecessary(instance, tagId, adGroupId, hit, config);
        boolean headTicket = this.isHeadTicket(config, adid);
        ClickLog clickLog = ClickLog.builder().adid(adid).clickId(clickId).app(app).config(config).clickKeyValueMap(clickKeyValueMap).isHeadTicket(headTicket).build();
        control.onAdClick(clickLog);
        this.eventPark.post((EventObject)new RatioAdClickEvent(this, control, adGroupId, app));
    }

    @Override
    public boolean onFeedbackControl(RtbIntegration instance, FeedbackRequest request) {
        String adGroupId = request.getAdGroupId();
        if (StringUtils.isBlank((String)adGroupId)) {
            return false;
        }
        if (!(instance instanceof ClickTracker)) {
            return false;
        }
        ClickTracker clickTracker = (ClickTracker)((Object)instance);
        KeyValueMap keyValueMap = request.getKeyValueMap();
        String tagId = (String)keyValueMap.getFirst((Object)"tagid");
        PositionRtb config = request.getConfig();
        if (Objects.isNull(config)) {
            return false;
        }
        PositionRtb.RatioControl hit = DefaultRatioControlRtbIntegrationImpl.chooseCvrControl(config, adGroupId);
        if (Objects.isNull(hit)) {
            return false;
        }
        String app = StringUtils.defaultIfBlank((String)clickTracker.getApp(keyValueMap), (String)"-");
        request.setAppid(app);
        RatioControl control = this.createIfNecessary(instance, tagId, adGroupId, hit, config);
        control.pushConversion(request, app);
        this.eventPark.post((EventObject)new RatioConversionEvent(this, control, adGroupId, app));
        return true;
    }

    private boolean isRepeatClick(ClickTracker clickTracker, String clickId) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = KeyBuilder.build((Object[])new Object[]{"rtb", "conv", "CLICK", clickTracker.rtb().getType(), clickId});
            Long rs = jedis.incr(key);
            jedis.expire(key, 3600);
            boolean bl = rs > 1L;
            return bl;
        }
    }

    private void refreshControlForMapping() {
        if (log.isDebugEnabled()) {
            log.debug("Starting refresh Ratio Controller...");
        }
        HashSet<String> alive = new HashSet<String>(this.referenced.values());
        HashSet removeIf = Sets.newHashSet();
        this.mapping.forEach((id, keys) -> keys.forEach(key -> {
            String tagId;
            PositionRtb config;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Checking {}", id, key);
            }
            if (Objects.isNull(config = this.service.get(tagId = ControlUtils.splitKey(key)[0]))) {
                removeIf.add(id);
                return;
            }
            List controls = config.getRatioControls();
            if (CollectionUtils.isEmpty((Collection)controls)) {
                removeIf.add(id);
                return;
            }
            if (!config.isCvrOrDeductionControl()) {
                removeIf.add(id);
                return;
            }
            if (!alive.contains(key)) {
                removeIf.add(id);
                return;
            }
            for (PositionRtb.RatioControl cfg : controls) {
                String endTime;
                if (!Objects.equals(id, cfg.getId())) continue;
                if (!cfg.isEnable()) {
                    removeIf.add(id);
                    continue;
                }
                String startTime = cfg.getStartTime();
                if (!DefaultRatioControlRtbIntegrationImpl.isValidTime(startTime, endTime = cfg.getEndTime())) {
                    removeIf.add(id);
                    continue;
                }
                this.refresh((Long)id, config, cfg);
            }
        }));
        removeIf.forEach(this::close);
        removeIf.forEach(this.mapping::remove);
        if (log.isInfoEnabled()) {
            log.info("Reference executor: {}, Need remove: {}, After remove on Mapping: {}", new Object[]{alive.size(), removeIf.size(), this.mapping.size()});
        }
    }

    private void refresh(Long id, PositionRtb rtbConfig, PositionRtb.RatioControl cfg) {
        Set<String> executors = this.mapping.get(id);
        if (CollectionUtils.isNotEmpty(executors)) {
            executors.forEach(key -> {
                RatioControl control = this.controlExecutors.get(key);
                if (Objects.nonNull(control)) {
                    RatioControlConfig config = control.getConfig();
                    RatioControlConfig newConfig = this.createRatioControlConfig(config.getDimension(), rtbConfig, cfg, config.getTagId(), config.getAdGroupId());
                    control.refreshConfig(newConfig);
                }
            });
        }
    }

    private void close(final Long id) {
        Set<String> executors = this.mapping.get(id);
        if (CollectionUtils.isNotEmpty(executors)) {
            executors.removeIf(new Predicate<String>(){

                @Override
                public boolean test(String key) {
                    RatioControl control = (RatioControl)DefaultRatioControlRtbIntegrationImpl.this.controlExecutors.get(key);
                    if (Objects.nonNull(control)) {
                        control.delete();
                        control.shutdown();
                    }
                    DefaultRatioControlRtbIntegrationImpl.this.controlExecutors.remove(key);
                    if (log.isInfoEnabled()) {
                        log.info("{} - Close control: {} - {}", new Object[]{id, key, control});
                    }
                    return true;
                }
            });
        }
    }

    private RatioControl createIfNecessary(final RtbIntegration instance, final String tagId, final String adGroupId, final PositionRtb.RatioControl hit, final PositionRtb config) {
        final String key = ControlUtils.createKey(tagId, adGroupId, TypeHelper.castToString((Object)hit.getId()), hit.getStartTime(), hit.getEndTime());
        return (RatioControl)SafeMapHelper.get(this.controlExecutors, (Object)key, (SafeMapHelper.InitializingValue)new SafeMapHelper.InitializingValue<RatioControl>(){

            public RatioControl initializing() {
                RatioControlConfig ratioControlConfig = DefaultRatioControlRtbIntegrationImpl.this.createRatioControlConfig(key, config, hit, tagId, adGroupId);
                RatioControlBus bus = RatioControlBus.builder().instance(instance).jedisPool(DefaultRatioControlRtbIntegrationImpl.this.jedisPool).registry(DefaultRatioControlRtbIntegrationImpl.this.registry).eventPark(DefaultRatioControlRtbIntegrationImpl.this.eventPark).zkClientHolder(DefaultRatioControlRtbIntegrationImpl.this.zkClientHolder).factory(DefaultRatioControlRtbIntegrationImpl.this.factory).positionRtbService(DefaultRatioControlRtbIntegrationImpl.this.service).build();
                RedisRatioControlImpl ratioControl = new RedisRatioControlImpl(bus, ratioControlConfig, DefaultRatioControlRtbIntegrationImpl.this.cpaControl, DefaultRatioControlRtbIntegrationImpl.this.plusQueueService);
                ratioControl.start();
                ((Set)SafeMapHelper.get((Map)DefaultRatioControlRtbIntegrationImpl.this.mapping, (Object)hit.getId(), HashSet::new)).add(key);
                String previous = DefaultRatioControlRtbIntegrationImpl.this.referenced.put(tagId + adGroupId, key);
                if (Objects.nonNull(previous)) {
                    log.info("Ratio control {} reference changed to {}", (Object)previous, (Object)key);
                }
                return ratioControl;
            }
        });
    }

    private RatioControlConfig createRatioControlConfig(String dimension, PositionRtb config, PositionRtb.RatioControl hit, String tagId, String adGroupId) {
        RatioControlConfig ratioControlConfig = new RatioControlConfig();
        PositionRtb.ControlStrategy controlStrategy = config.getControlStrategy();
        if (Objects.nonNull(controlStrategy)) {
            RatioControlConfig.PlusStrategy strategy;
            RatioControlConfig.Duration2 duration2 = RatioControlConfig.Duration2.of(controlStrategy.getDuration());
            if (Objects.nonNull((Object)duration2)) {
                ratioControlConfig.setDuration(duration2);
            }
            if (Objects.nonNull((Object)(strategy = RatioControlConfig.PlusStrategy.of(controlStrategy.getPlusStrategy())))) {
                ratioControlConfig.setPlusStrategy(strategy);
            }
        }
        return ratioControlConfig.setTagId(tagId).setAdvertiserId(config.getCustomerId()).setAdGroupId(adGroupId).setDimension(dimension).setHitConfigId(hit.getId()).setRatio(Optional.ofNullable(hit.getCvr()).orElse(0.0)).setDeductionShallowRatio(Optional.ofNullable(hit.getShallowRatio()).orElse(0.0)).setDeductionDeepRatio(Optional.ofNullable(hit.getDeepRatio()).orElse(0.0)).setCost(Optional.ofNullable(hit.getCost()).orElse(0.0)).setExpireInHours(48).setDataFetchInMinute(5).setShallowEventType(config.getTargetOneRtb()).setDeepEventType(config.getTargetTwoRtb()).setEnableCvrControl(hit.isEnableCvrControl()).setEnableDeductionControl(hit.isEnableDeductionControl()).setEnableCostControl(hit.isEnableCostControl()).setConversionLevel(Optional.ofNullable(config.getTargetType()).filter(t -> t == 2).map(t -> ConversionLevel.DEEP).orElse(ConversionLevel.SHALLOW)).setLimitUnconvs(hit.getLimitUnconv()).setAdvertiserName(config.getSourceId());
    }

    public static PositionRtb.RatioControl chooseCvrControl(PositionRtb config, String adGroupId) {
        List ratioControls = config.getRatioControls();
        if (CollectionUtils.isEmpty((Collection)ratioControls)) {
            return null;
        }
        PositionRtb.RatioControl hit = null;
        for (PositionRtb.RatioControl ratioControl : ratioControls) {
            String endTime;
            if (!ratioControl.isEnable()) continue;
            String theAdGroupId = ratioControl.getAdGroupId();
            String startTime = ratioControl.getStartTime();
            if (!DefaultRatioControlRtbIntegrationImpl.isValidTime(startTime, endTime = ratioControl.getEndTime())) continue;
            if (StringUtils.isBlank((String)theAdGroupId)) {
                hit = ratioControl;
            }
            if (!StringUtils.equals((String)adGroupId, (String)theAdGroupId)) continue;
            hit = ratioControl;
            break;
        }
        return hit;
    }

    private static boolean isValidTime(String startTime, String endTime) {
        LocalTime start = LocalDateTimeUtils.parseTime(startTime);
        LocalTime end = LocalDateTimeUtils.parseTime(endTime);
        if (Objects.isNull(start) || Objects.isNull(end)) {
            return false;
        }
        LocalTime now = LocalTime.now().withNano(0);
        return now.equals(start) || now.equals(end) || now.isAfter(start) && now.isBefore(end);
    }
}

