/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateTimeUtils {
    private static final Logger log = LoggerFactory.getLogger(LocalDateTimeUtils.class);

    public static LocalDate parseDate(String date) {
        if (StringUtils.isBlank((String)date)) {
            log.error("date is null");
            return null;
        }
        try {
            return LocalDate.from(DateTimeFormatter.ofPattern("yyyy-MM-dd").parse(date));
        }
        catch (Exception e) {
            log.error("from: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static LocalTime parseTime(String time) {
        if (StringUtils.isBlank((String)time)) {
            log.error("time is null");
            return null;
        }
        try {
            return LocalTime.from(DateTimeFormatter.ofPattern("HH:mm:ss").parse(time));
        }
        catch (Exception e) {
            log.error("from: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static LocalDateTime of(long timeInMillis) {
        return Instant.ofEpochMilli(timeInMillis).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

