/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.cpa;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.RtbRedisKeys;
import com.bxm.adscounter.rtb.common.control.cpa.CpaControl;
import com.bxm.adscounter.rtb.common.control.cpa.PreSummaryFeedbackHelper;
import com.bxm.adscounter.rtb.common.control.hosting.HostingResult;
import com.bxm.adscounter.rtb.common.control.hosting.event.HostingPlusEvent;
import com.bxm.adscounter.rtb.common.control.plus.PlusQueueService;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adsprod.facade.ticket.rtb.HostingConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public abstract class AbstractSummaryCpaControl
implements CpaControl {
    private static final Logger log = LoggerFactory.getLogger(AbstractSummaryCpaControl.class);
    protected static final int ONE_DAY_SEC = TypeHelper.castToInt((Object)Duration.ofDays(1L).getSeconds());
    protected static final int MONTH_DAYS_SEC = TypeHelper.castToInt((Object)Duration.ofDays(30L).getSeconds());
    protected final Counter counter;
    protected final Fetcher fetcher;
    protected final Updater updater;
    protected final RtbProperties properties;
    protected final OpenLogClient openLogClient;
    protected final JedisPool jedisPool;
    protected final PreSummaryFeedbackHelper preSummaryFeedbackHelper;
    protected final PlusQueueService plusQueueService;
    protected final EventPark eventPark;

    public AbstractSummaryCpaControl(Counter counter, Fetcher fetcher, Updater updater, RtbProperties properties, OpenLogClient openLogClient, JedisPool jedisPool, PreSummaryFeedbackHelper preSummaryFeedbackHelper, PlusQueueService plusQueueService, EventPark eventPark) {
        this.counter = counter;
        this.fetcher = fetcher;
        this.updater = updater;
        this.properties = properties;
        this.openLogClient = openLogClient;
        this.jedisPool = jedisPool;
        this.preSummaryFeedbackHelper = preSummaryFeedbackHelper;
        this.plusQueueService = plusQueueService;
        this.eventPark = eventPark;
    }

    @Override
    public abstract boolean isFeedback(FeedbackRequest var1, RtbIntegration var2);

    public boolean needPushConversion() {
        return true;
    }

    @Override
    public List<FeedbackRequest> getOnConversionQueue(String positionId, List<String> adGroupIds, Integer size) {
        if (size <= 0) {
            return Collections.emptyList();
        }
        ArrayList<FeedbackRequest> results = new ArrayList<FeedbackRequest>();
        block0: for (String adGroupId : adGroupIds) {
            String pop;
            if (results.size() >= size) break;
            String key = AbstractSummaryCpaControl.listConversionQueue(positionId, adGroupId).generateKey();
            while (!StringUtils.isBlank((String)(pop = this.leftPop(key)))) {
                FeedbackRequest feedbackRequest = (FeedbackRequest)JsonHelper.convert((String)pop, FeedbackRequest.class);
                results.add(feedbackRequest);
                if (results.size() < size) continue;
                continue block0;
            }
        }
        return results;
    }

    @Override
    public void pushConversion(FeedbackRequest feedbackRequest) {
        PositionRtb config = feedbackRequest.getConfig();
        if (config.isEnableSmartHosting()) {
            String adGroupId = feedbackRequest.getAdGroupId();
            String positionId = config.getPositionId();
            String data = JsonHelper.convert((Object)feedbackRequest);
            if (log.isInfoEnabled()) {
                log.info("\u7d2f\u52a0\u56de\u4f20\u6682\u5b58\u6570\u636e...{} - {}", (Object)positionId, (Object)adGroupId);
            }
            this.addConversion(positionId, adGroupId, data);
        }
    }

    @Override
    public long getQueueSize(String positionId, List<String> adGroupIds) {
        long length = 0L;
        for (String adGroupId : adGroupIds) {
            String key = AbstractSummaryCpaControl.listConversionQueue(positionId, adGroupId).generateKey();
            length += this.queueLength(key);
        }
        return length;
    }

    protected boolean isFeedbackBySummary(FeedbackRequest feedbackRequest, Integer rtbTargetCpa, int price, KeyGenerator redisKey) {
        boolean isFeedback;
        Long cpaBalance = this.counter.hincrementByAndGet(redisKey, "cpa_balance", (long)price);
        boolean bl = isFeedback = cpaBalance >= (long)rtbTargetCpa.intValue();
        if (log.isDebugEnabled()) {
            log.debug("[{}] After Incr Balance={} , this price={} , isFeedback={}", new Object[]{redisKey.generateKey(), cpaBalance, price, isFeedback});
        }
        if (isFeedback) {
            Long balanceAfterDecr = this.counter.hincrementByAndGet(redisKey, "cpa_balance", (long)(-rtbTargetCpa.intValue()));
            if (log.isDebugEnabled()) {
                log.debug("[{}] After Decr Balance={}", (Object)redisKey.generateKey(), (Object)balanceAfterDecr);
            }
        } else if (this.needPushConversion()) {
            this.pushConversion(feedbackRequest);
            this.plusQueueService.pushConversion(feedbackRequest);
        }
        this.counter.hincrementByAndGet(redisKey, "summary_cpa", (long)price);
        this.counter.expire(redisKey, ONE_DAY_SEC);
        return isFeedback;
    }

    protected boolean preFeedbackIfNeeded(PositionRtb positionRtb, String positionId, String adGroupId) {
        if (positionRtb.isPreSummaryFeedback()) {
            return this.preSummaryFeedbackHelper.needFeedback(positionRtb, adGroupId);
        }
        boolean isInitialized = this.counter.incrementAndGet(this.strInitSummary(positionId, adGroupId), MONTH_DAYS_SEC) > 1L;
        return !isInitialized;
    }

    protected Boolean processSummaryCpaMode(String positionId, String adGroupId, KeyGenerator redisKey, int price, FeedbackRequest feedbackRequest, RtbIntegration integration, PositionRtb positionRtb) {
        Long decr;
        String hostingConfig = positionRtb.getHostingConfig();
        List<HostingConfig> hostingConfigs = this.convertHostingConfig(hostingConfig);
        if (CollectionUtils.isEmpty(hostingConfigs)) {
            return null;
        }
        String dimension = this.chooseDimension(hostingConfigs, adGroupId);
        if (StringUtils.isBlank((String)dimension)) {
            return null;
        }
        Integer summaryCpaMode = (Integer)this.fetcher.fetch(RtbRedisKeys.strAdGroupSummaryCpaMode(positionId, dimension), Integer.class);
        log.info("[\u7d2f\u52a0-\u667a\u80fd\u6258\u7ba1] {} - {} - mode{}", new Object[]{positionId, dimension, summaryCpaMode});
        if (Objects.equals(summaryCpaMode, 1)) {
            log.info("[\u7d2f\u52a0-\u667a\u80fd\u6258\u7ba1] \u53ea\u7d2f\u52a0\uff0c\u4e0d\u56de\u4f20 {} - {} - mode{}", new Object[]{positionId, dimension, summaryCpaMode});
            this.counter.hincrementByAndGet(redisKey, "cpa_balance", (long)price);
            return false;
        }
        if (Objects.equals(summaryCpaMode, 2) && (decr = this.counter.decrementAndGet(RtbRedisKeys.strHostingRemainPlusNum(positionId, dimension))) >= 0L) {
            log.info("[\u7d2f\u52a0-\u667a\u80fd\u6258\u7ba1] \u672c\u6b21\u4e0d\u7d2f\u52a0\uff0c\u76f4\u63a5\u56de\u4f20 {} - {} - mode{} - \u5269\u4f59\u8865:{}", new Object[]{positionId, dimension, summaryCpaMode, decr});
            this.eventPark.post((EventObject)new HostingPlusEvent(this, Lists.newArrayList((Object[])new FeedbackRequest[]{feedbackRequest}), integration, positionId, dimension));
            if (decr == 0L) {
                this.resetMode(positionId, dimension);
            }
            return false;
        }
        return null;
    }

    private String chooseDimension(List<HostingConfig> hostingConfigs, String adGroupId) {
        for (HostingConfig hostingConfig : hostingConfigs) {
            if (!Objects.equals(hostingConfig.getDimension(), adGroupId)) continue;
            return adGroupId;
        }
        boolean existAccount = hostingConfigs.stream().anyMatch(config -> Objects.equals("ACCOUNT", config.getDimension()));
        if (existAccount) {
            return "ACCOUNT";
        }
        return null;
    }

    public KeyGenerator strInitSummary(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "cpa_init", positionId, adGroupId});
    }

    public KeyGenerator hashRtbCpa(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "cpa", positionId, adGroupId, AbstractSummaryCpaControl.getDate()});
    }

    private static String getDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    protected void sendOpenLog(String positionId, String adGroupId, Integer rtbId, Integer thisPrice, Integer summarySourceType, String controlDimension, Double controlRatio, Integer rtbTargetCpa) {
        Map rtbCpaData = this.fetcher.hfetchall(this.hashRtbCpa(positionId, adGroupId), Long.class);
        Long summaryCpa = Optional.ofNullable(rtbCpaData.get("summary_cpa")).orElse(0L);
        Long cpaBalance = Optional.ofNullable(rtbCpaData.get("cpa_balance")).orElse(0L);
        KeyValueMap map = new KeyValueMap();
        map.put("p", Production.COMMON.getName());
        map.put("mt", Common.Mt.RtbSummaryCpa.original());
        map.put("time", (Object)System.currentTimeMillis());
        map.put("tagid", positionId);
        map.put("rtb_id", (Object)rtbId);
        map.put("ad_group_id", adGroupId);
        map.put("summary_cpa", (Object)summaryCpa);
        map.put("summary_cpa_balance", (Object)cpaBalance);
        map.put("this_price", (Object)thisPrice);
        map.put("summary_source_type", (Object)summarySourceType);
        map.put("control_dimension", controlDimension);
        map.put("control_ratio", (Object)controlRatio);
        map.put("rtb_target_cpa", (Object)rtbTargetCpa);
        String openLogRequestUri = map.createOpenLogRequestUri(this.properties.getOpenLogRequestDomain());
        if (log.isDebugEnabled()) {
            log.debug("summary send openlog : {}", (Object)openLogRequestUri);
        }
        this.openLogClient.asyncRequest(openLogRequestUri);
    }

    public boolean isConversionValid(KeyValueMap map) {
        return StringUtils.equalsIgnoreCase((String)((String)map.getFirst((Object)"conversion_valid")), (String)"1");
    }

    static KeyGenerator listConversionQueue(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "summary_feedback", "CONV_QUEUE", AbstractSummaryCpaControl.getHour(), positionId, adGroupId});
    }

    private static String getHour() {
        return DateHelper.format((String)"yyyyMMddHH");
    }

    private void addConversion(String positionId, String adGroupId, String data) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            String key = AbstractSummaryCpaControl.listConversionQueue(positionId, adGroupId).generateKey();
            jedis.lpush(key, new String[]{data});
            jedis.expire(key, 86400);
        }
    }

    public void resetMode(String positionId, String dimension) {
        this.updater.remove(RtbRedisKeys.strAdGroupSummaryCpaMode(positionId, dimension));
        HostingResult hostingResult = (HostingResult)this.fetcher.fetch(RtbRedisKeys.strHostingData(positionId, dimension), HostingResult.class);
        if (Objects.isNull(hostingResult)) {
            return;
        }
        ArrayList accountAdGroupIds = hostingResult.getAccountAdGroupIds();
        if (CollectionUtils.isEmpty(accountAdGroupIds)) {
            return;
        }
        ArrayList adGroupIds = Objects.equals(dimension, "ACCOUNT") ? accountAdGroupIds : Lists.newArrayList((Object[])new String[]{dimension});
        for (String adGroupId : adGroupIds) {
            this.updater.remove(RtbRedisKeys.strAlgSmartHostingSwitch(positionId, adGroupId));
        }
        log.info("[{}-{}]\u7d2f\u52a0\u5df2\u5207\u6362\u9ed8\u8ba4\u72b6\u6001\uff08\u539f\u56e0\uff1a{}\uff09", new Object[]{positionId, dimension, "\u5269\u4f59\u7684\u5f85\u8865\u91cf\u6570\u5df2\u5b8c\u6210"});
    }

    private List<HostingConfig> convertHostingConfig(String hostingConfig) {
        if (StringUtils.isBlank((String)hostingConfig)) {
            return null;
        }
        return JSONObject.parseArray((String)hostingConfig, HostingConfig.class);
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String leftPop(String key) {
        try (Jedis jedis = this.getJedisPool().getResource();){
            String string = jedis.lpop(key);
            return string;
        }
        catch (Exception e) {
            log.error("lpop: {}", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long queueLength(String key) {
        try (Jedis jedis = this.getJedisPool().getResource();){
            long l = jedis.llen(key);
            return l;
        }
        catch (Exception e) {
            log.error("lpop: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public static KeyGenerator hashAdvertiserRebateRate() {
        return () -> KeyBuilder.build((Object[])new Object[]{"advertiser", "rebate_rate"});
    }

    public static interface Field {
        public static final String CPA_BALANCE = "cpa_balance";
        public static final String SUMMARY_CPA = "summary_cpa";
    }
}

