/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.cpa;

import com.alibaba.fastjson.JSON;
import com.bxm.adscounter.rtb.common.DataFetchFailException;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.data.DorisAdGroupHourlyData;
import com.bxm.adscounter.rtb.common.data.Parameter;
import com.bxm.adscounter.rtb.common.impl.kuaishou.KuaishouDataFetcher;
import com.bxm.adscounter.rtb.common.mapper.DorisMapper;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.adsprod.facade.ticket.rtb.PreSummaryFeedbackConfig;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreSummaryFeedbackHelper {
    private static final Logger log = LoggerFactory.getLogger(PreSummaryFeedbackHelper.class);
    private static final int ONE_DAY_SEC = TypeHelper.castToInt((Object)Duration.ofDays(1L).getSeconds());
    private final Counter counter;
    private final Fetcher fetcher;
    private final KuaishouDataFetcher kuaishouDataFetcher;
    private final DorisMapper dorisMapper;

    public PreSummaryFeedbackHelper(Counter counter, Fetcher fetcher, KuaishouDataFetcher kuaishouDataFetcher, DorisMapper dorisMapper) {
        this.counter = counter;
        this.fetcher = fetcher;
        this.kuaishouDataFetcher = kuaishouDataFetcher;
        this.dorisMapper = dorisMapper;
    }

    public boolean needFeedback(PositionRtb positionRtb, String adGroupId) {
        if (!positionRtb.isPreSummaryFeedback()) {
            return false;
        }
        String positionId = positionRtb.getPositionId();
        FinalActiveParameter finalActiveParameter = this.getFinalActiveParameter(positionId, adGroupId, positionRtb);
        String dimension = finalActiveParameter.isUseAccountDimension() ? "ACCOUNT" : adGroupId;
        BigDecimal lossThreshold = finalActiveParameter.getLossThreshold();
        if (this.needFeedbackIfAchieveLossThreshold(lossThreshold, positionRtb, positionId, dimension)) {
            log.info("PreSummary {} - {} needFeedbackIfAchieveLossThreshold return true. finalActiveParameter = {}", new Object[]{positionId, dimension, JSON.toJSONString((Object)finalActiveParameter)});
            return true;
        }
        Integer feedbackMaxNum = finalActiveParameter.getFeedbackMaxNum();
        if (feedbackMaxNum == null) {
            return false;
        }
        Integer count = (Integer)Optional.ofNullable(this.fetcher.hfetch(PreSummaryFeedbackHelper.hashPreSummaryFeedbackCount(positionId), dimension, Integer.class)).orElse(0);
        if (count >= feedbackMaxNum) {
            return false;
        }
        Long afterIncr = this.counter.hincrementAndGet(PreSummaryFeedbackHelper.hashPreSummaryFeedbackCount(positionId), dimension, ONE_DAY_SEC);
        return afterIncr <= (long)feedbackMaxNum.intValue();
    }

    public boolean isEnough(PositionRtb positionRtb, String adGroupId) {
        if (!positionRtb.isPreSummaryFeedback()) {
            return true;
        }
        String positionId = positionRtb.getPositionId();
        FinalActiveParameter finalActiveParameter = this.getFinalActiveParameter(positionId, adGroupId, positionRtb);
        String dimension = finalActiveParameter.isUseAccountDimension() ? "ACCOUNT" : adGroupId;
        Integer feedbackMaxNum = finalActiveParameter.getFeedbackMaxNum();
        if (feedbackMaxNum == null) {
            return true;
        }
        Integer count = (Integer)Optional.ofNullable(this.fetcher.hfetch(PreSummaryFeedbackHelper.hashPreSummaryFeedbackCount(positionId), dimension, Integer.class)).orElse(0);
        return count >= feedbackMaxNum;
    }

    private boolean needFeedbackIfAchieveLossThreshold(BigDecimal lossThreshold, PositionRtb positionRtb, String positionId, String adGroupId) {
        if (lossThreshold == null) {
            return false;
        }
        if (!Objects.equals(1, positionRtb.getSourceType())) {
            return false;
        }
        BigDecimal count = (BigDecimal)Optional.ofNullable(this.fetcher.hfetch(PreSummaryFeedbackHelper.hashPreSummaryFeedbackLossThresholdCount(positionId), adGroupId, BigDecimal.class)).orElse(BigDecimal.ZERO);
        log.info("[{} - {}] maxLossThreshold: {}, actualLossThreshold:{}", new Object[]{positionId, adGroupId, lossThreshold, count});
        if (lossThreshold.compareTo(count) < 0) {
            return false;
        }
        BigDecimal income = this.getAdGroupIncome(positionId, adGroupId);
        if (income == null) {
            return false;
        }
        BigDecimal charge = this.getAdGroupCharge(positionRtb, adGroupId);
        if (charge == null) {
            return false;
        }
        BigDecimal profit = this.computeProfit(income, charge);
        Double afterIncr = this.counter.hincrFloatByAndGet(PreSummaryFeedbackHelper.hashPreSummaryFeedbackLossThresholdCount(positionId), adGroupId, profit.doubleValue());
        return lossThreshold.compareTo(BigDecimal.valueOf(afterIncr)) > 0;
    }

    private BigDecimal getAdGroupCharge(PositionRtb positionRtb, String adGroupId) {
        if (this.isAccountDimension(adGroupId)) {
            adGroupId = null;
        }
        Parameter parameter = Parameter.builder().tagId(positionRtb.getPositionId()).adGroupId(adGroupId).build();
        List<AdGroupData> adGroupData = null;
        try {
            adGroupData = this.kuaishouDataFetcher.fetchCurrentHourData(parameter);
        }
        catch (DataFetchFailException e) {
            log.error("preSummary getAdGroupCharge occur error", (Throwable)e);
            return null;
        }
        BigDecimal charge = null;
        if (CollectionUtils.isNotEmpty(adGroupData)) {
            charge = adGroupData.stream().map(AdGroupData::getCharge).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return charge;
    }

    private BigDecimal getAdGroupIncome(String positionId, String adGroupId) {
        List<DorisAdGroupHourlyData> dorisAdGroupHourlyData;
        BigDecimal income = null;
        if (this.isAccountDimension(adGroupId)) {
            adGroupId = null;
        }
        if (CollectionUtils.isNotEmpty(dorisAdGroupHourlyData = this.dorisMapper.getAdGroupHourlyData(positionId, adGroupId, DateHelper.format((String)"yyyy-MM-dd"), DateHelper.format((String)"HH")))) {
            income = dorisAdGroupHourlyData.stream().map(DorisAdGroupHourlyData::getIncome).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return income;
    }

    private FinalActiveParameter getFinalActiveParameter(String positionId, String adGroupId, PositionRtb positionRtb) {
        PreSummaryFeedbackConfig preSummaryFeedbackConfig;
        BigDecimal lossThreshold;
        PreSummaryFeedbackConfig preSummaryFeedbackConfig2;
        Integer max = this.fetchMaxFromCache(positionId, adGroupId);
        boolean useAccountDimension = false;
        if (max == null && (max = this.fetchMaxFromCache(positionId, "-")) == null) {
            max = this.fetchMaxFromCache(positionId, "ACCOUNT");
            boolean bl = useAccountDimension = max != null;
        }
        if (max == null && (preSummaryFeedbackConfig2 = this.getPreSummaryFeedbackConfig(positionRtb)) != null && (max = this.fetchMaxFromAdGroupConfigs(preSummaryFeedbackConfig2.getAdGroupConfigs(), adGroupId)) == null && (max = this.fetchMaxFromAdGroupConfigs(preSummaryFeedbackConfig2.getAdGroupConfigs(), "")) == null) {
            max = preSummaryFeedbackConfig2.getAccountMax();
            boolean bl = useAccountDimension = max != null;
        }
        if ((lossThreshold = this.fetchLossThresholdFromCache(positionId, adGroupId)) == null && (lossThreshold = this.fetchLossThresholdFromCache(positionId, "-")) == null) {
            lossThreshold = this.fetchLossThresholdFromCache(positionId, "ACCOUNT");
        }
        if (lossThreshold == null && (preSummaryFeedbackConfig = this.getPreSummaryFeedbackConfig(positionRtb)) != null && (lossThreshold = this.fetchLossThresholdFromAdGroupConfigs(preSummaryFeedbackConfig.getAdGroupConfigs(), adGroupId)) == null && (lossThreshold = this.fetchLossThresholdFromAdGroupConfigs(preSummaryFeedbackConfig.getAdGroupConfigs(), "")) == null) {
            lossThreshold = preSummaryFeedbackConfig.getAccountLossThreshold();
        }
        return new FinalActiveParameter().setFeedbackMaxNum(max).setLossThreshold(lossThreshold).setUseAccountDimension(useAccountDimension);
    }

    private Integer fetchMaxFromCache(String positionId, String dimension) {
        return (Integer)this.fetcher.hfetch(PreSummaryFeedbackHelper.hashPreSummaryFeedbackConf(positionId), dimension, Integer.class);
    }

    private BigDecimal fetchLossThresholdFromCache(String positionId, String dimension) {
        return (BigDecimal)this.fetcher.hfetch(PreSummaryFeedbackHelper.hashPreSummaryFeedbackLossThreshold(positionId), dimension, BigDecimal.class);
    }

    private Integer fetchMaxFromAdGroupConfigs(List<PreSummaryFeedbackConfig.AdGroupConfig> adGroupConfigs, String adGroupId) {
        return adGroupConfigs.stream().filter(config -> Objects.equals(config.getAdGroupId(), adGroupId)).findFirst().map(PreSummaryFeedbackConfig.AdGroupConfig::getMax).orElse(null);
    }

    private BigDecimal fetchLossThresholdFromAdGroupConfigs(List<PreSummaryFeedbackConfig.AdGroupConfig> adGroupConfigs, String adGroupId) {
        return adGroupConfigs.stream().filter(config -> Objects.equals(config.getAdGroupId(), adGroupId)).findFirst().map(PreSummaryFeedbackConfig.AdGroupConfig::getLossThreshold).orElse(null);
    }

    private PreSummaryFeedbackConfig getPreSummaryFeedbackConfig(PositionRtb positionRtb) {
        String preSummaryFeedbackConf = positionRtb.getPreSummaryFeedbackConf();
        if (StringUtils.isNotBlank((String)preSummaryFeedbackConf)) {
            return (PreSummaryFeedbackConfig)JsonHelper.convert((String)preSummaryFeedbackConf, PreSummaryFeedbackConfig.class);
        }
        return null;
    }

    public static KeyGenerator hashPreSummaryFeedbackConf(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "pre_summary_feedback", "conf", PreSummaryFeedbackHelper.getDate(), positionId});
    }

    public static KeyGenerator hashPreSummaryFeedbackCount(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "pre_summary_feedback", "count", PreSummaryFeedbackHelper.getDate(), positionId});
    }

    public static KeyGenerator hashPreSummaryFeedbackLossThreshold(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "pre_summary_feedback", "loss_threshold", PreSummaryFeedbackHelper.getDate(), positionId});
    }

    public static KeyGenerator hashPreSummaryFeedbackLossThresholdCount(String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "pre_summary_feedback", "loss_threshold_count", PreSummaryFeedbackHelper.getDate(), positionId});
    }

    private static String getDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    private BigDecimal computeProfit(BigDecimal income, BigDecimal charge) {
        BigDecimal profit = charge.subtract(income);
        log.info("computeProfit({}) = {} - {}", new Object[]{profit, charge, income});
        return profit;
    }

    private boolean isAccountDimension(String adGroupId) {
        return Objects.equals(adGroupId, "ACCOUNT");
    }

    private static class FinalActiveParameter {
        private Integer feedbackMaxNum;
        private BigDecimal lossThreshold;
        private boolean useAccountDimension;

        public Integer getFeedbackMaxNum() {
            return this.feedbackMaxNum;
        }

        public BigDecimal getLossThreshold() {
            return this.lossThreshold;
        }

        public boolean isUseAccountDimension() {
            return this.useAccountDimension;
        }

        public FinalActiveParameter setFeedbackMaxNum(Integer feedbackMaxNum) {
            this.feedbackMaxNum = feedbackMaxNum;
            return this;
        }

        public FinalActiveParameter setLossThreshold(BigDecimal lossThreshold) {
            this.lossThreshold = lossThreshold;
            return this;
        }

        public FinalActiveParameter setUseAccountDimension(boolean useAccountDimension) {
            this.useAccountDimension = useAccountDimension;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FinalActiveParameter)) {
                return false;
            }
            FinalActiveParameter other = (FinalActiveParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUseAccountDimension() != other.isUseAccountDimension()) {
                return false;
            }
            Integer this$feedbackMaxNum = this.getFeedbackMaxNum();
            Integer other$feedbackMaxNum = other.getFeedbackMaxNum();
            if (this$feedbackMaxNum == null ? other$feedbackMaxNum != null : !((Object)this$feedbackMaxNum).equals(other$feedbackMaxNum)) {
                return false;
            }
            BigDecimal this$lossThreshold = this.getLossThreshold();
            BigDecimal other$lossThreshold = other.getLossThreshold();
            return !(this$lossThreshold == null ? other$lossThreshold != null : !((Object)this$lossThreshold).equals(other$lossThreshold));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FinalActiveParameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseAccountDimension() ? 79 : 97);
            Integer $feedbackMaxNum = this.getFeedbackMaxNum();
            result = result * 59 + ($feedbackMaxNum == null ? 43 : ((Object)$feedbackMaxNum).hashCode());
            BigDecimal $lossThreshold = this.getLossThreshold();
            result = result * 59 + ($lossThreshold == null ? 43 : ((Object)$lossThreshold).hashCode());
            return result;
        }

        public String toString() {
            return "PreSummaryFeedbackHelper.FinalActiveParameter(feedbackMaxNum=" + this.getFeedbackMaxNum() + ", lossThreshold=" + this.getLossThreshold() + ", useAccountDimension=" + this.isUseAccountDimension() + ")";
        }
    }
}

