/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.cpa;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbProperties;
import com.bxm.adscounter.rtb.common.control.cpa.AbstractSummaryCpaControl;
import com.bxm.adscounter.rtb.common.control.cpa.PreSummaryFeedbackHelper;
import com.bxm.adscounter.rtb.common.control.plus.PlusQueueService;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.util.Objects;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

public class SummaryCpaControlImpl
extends AbstractSummaryCpaControl {
    private static final Logger log = LoggerFactory.getLogger(SummaryCpaControlImpl.class);

    public SummaryCpaControlImpl(Counter counter, Fetcher fetcher, Updater updater, RtbProperties properties, OpenLogClient openLogClient, JedisPool jedisPool, PreSummaryFeedbackHelper preSummaryFeedbackHelper, PlusQueueService plusQueueService, EventPark eventPark) {
        super(counter, fetcher, updater, properties, openLogClient, jedisPool, preSummaryFeedbackHelper, plusQueueService, eventPark);
    }

    @Override
    public boolean isFeedback(FeedbackRequest feedbackRequest, RtbIntegration integration) {
        PositionRtb positionRtb = feedbackRequest.getConfig();
        KeyValueMap keyValueMap = feedbackRequest.getKeyValueMap();
        String positionId = positionRtb.getPositionId();
        String adGroupId = feedbackRequest.getAdGroupId();
        Integer rtbTargetCpa = positionRtb.getRtbTargetCpa();
        if (!positionRtb.isFeedbackModeSummaryCpa()) {
            return true;
        }
        if (positionRtb.isSummaryByIncome()) {
            return false;
        }
        if (!this.isConversionValid(keyValueMap)) {
            return false;
        }
        if (rtbTargetCpa == null) {
            return true;
        }
        int ocpaOfferPrice = this.getOcpaOfferPrice(keyValueMap, rtbTargetCpa);
        KeyGenerator redisKey = this.hashRtbCpa(positionId, adGroupId);
        if (positionRtb.isEnableSmartHosting()) {
            try {
                Boolean processResult = this.processSummaryCpaMode(positionId, adGroupId, redisKey, ocpaOfferPrice, feedbackRequest, integration, positionRtb);
                if (Objects.nonNull(processResult)) {
                    return processResult;
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        if (this.preFeedbackIfNeeded(positionRtb, positionId, adGroupId)) {
            return true;
        }
        boolean isFeedback = this.isFeedbackBySummary(feedbackRequest, rtbTargetCpa, ocpaOfferPrice, redisKey);
        this.sendOpenLog(positionId, adGroupId, positionRtb.getSourceType(), ocpaOfferPrice, 0, null, null, rtbTargetCpa);
        return isFeedback;
    }

    protected int getOcpaOfferPrice(KeyValueMap keyValueMap, Integer rtbTargetCpa) {
        int ocpaOfferPrice = NumberUtils.toInt((String)((String)keyValueMap.getFirst((Object)"ocpa_offer_price")));
        if (!Objects.equals(rtbTargetCpa, 0)) {
            int limitOfferPrice = 3 * rtbTargetCpa;
            ocpaOfferPrice = Math.min(ocpaOfferPrice, limitOfferPrice);
        }
        return ocpaOfferPrice;
    }
}

