/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.db;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.rtb.common.control.db.DBFetchRequest;
import com.bxm.adscounter.rtb.common.data.QueryParam;
import com.bxm.adscounter.rtb.common.data.SrcAdUserAccessLog;
import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.adscounter.rtb.common.mapper.SrcAdUserAccessLogMapper;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class DBFeedbackFetcher {
    private static final Logger log = LoggerFactory.getLogger(DBFeedbackFetcher.class);
    private final SrcAdUserAccessLogMapper srcAdUserAccessLogMapper;
    private final JedisPool jedisPool;

    public DBFeedbackFetcher(SrcAdUserAccessLogMapper srcAdUserAccessLogMapper, JedisPool jedisPool) {
        this.srcAdUserAccessLogMapper = srcAdUserAccessLogMapper;
        this.jedisPool = jedisPool;
    }

    public List<FeedbackRequest> fetch(DBFetchRequest request) {
        ArrayList result = Lists.newArrayList();
        PositionRtb positionRtb = request.getPositionRtb();
        int size = Optional.ofNullable(request.getSize()).orElse(10);
        String positionId = positionRtb.getPositionId();
        List<String> fetchAdGroupIds = request.getFetchAdGroupIds();
        int currentPage = 1;
        try {
            do {
                QueryParam queryParam = QueryParam.builder().positionId(positionId).startTime(request.getStartTime()).endTime(request.getEndTime()).action(request.getAction()).adGroupId(fetchAdGroupIds).isValidConversion(request.getIsValidConversion()).date(request.getDate()).hour(request.getHour()).build();
                PageHelper.startPage((int)currentPage, (int)size);
                List<SrcAdUserAccessLog> list = this.srcAdUserAccessLogMapper.list(queryParam);
                if (CollectionUtils.isEmpty(list)) {
                    return null;
                }
                for (SrcAdUserAccessLog srcAdUserAccessLog : list) {
                    FeedbackRequest of = this.of(srcAdUserAccessLog, positionRtb, request.getActionType());
                    if (!Objects.nonNull(of) || this.existClickId(positionId, of.getClickId()) || size <= result.size() || !fetchAdGroupIds.contains(of.getAdGroupId())) continue;
                    result.add(of);
                }
                ++currentPage;
            } while (size > result.size());
        }
        catch (Exception e) {
            log.error("Fetch from db occur error", (Throwable)e);
        }
        log.info("Fetch conversion from db - {}", (Object)JSON.toJSONString((Object)result));
        return result;
    }

    private FeedbackRequest of(SrcAdUserAccessLog log, PositionRtb positionRtbConfig, ActionType actionType) {
        String rtbExt = log.getRtbExt();
        String clickId = null;
        if (StringUtils.isNotBlank((String)rtbExt)) {
            JSONObject rtbExtJsonObject = (JSONObject)JsonHelper.convert((String)rtbExt, JSONObject.class);
            clickId = rtbExtJsonObject.getString("click_id");
        }
        KeyValueMap keyValueMap = new KeyValueMap();
        keyValueMap.put("oaid", log.getOaid());
        keyValueMap.put("oaid_md5", log.getOaidMd5());
        keyValueMap.put("imei", log.getImei());
        keyValueMap.put("imei_md5", log.getImeiMd5());
        keyValueMap.put("idfa", log.getIdfa());
        keyValueMap.put("idfa_md5", log.getIdfaMd5());
        keyValueMap.put("androidid", log.getAnid());
        keyValueMap.put("androidid_md5", log.getAnidMd5());
        keyValueMap.put("bxmid", log.getBxmId());
        keyValueMap.put("ip", log.getIp());
        keyValueMap.put("ua", log.getUas());
        keyValueMap.put("uid", log.getUid());
        keyValueMap.put("time", log.getTimeStamp());
        keyValueMap.put("adid", log.getPreId());
        keyValueMap.put("tagid", positionRtbConfig.getPositionId());
        return FeedbackRequest.builder().config(positionRtbConfig).conversionLevel(1).conversionType("0").smartConvType(SmartConvType.NONE).referrer(log.getRefer()).adGroupId(log.getAdGroupId()).clickId(clickId).eventType(positionRtbConfig.getTargetOneRtb()).keyValueMap(keyValueMap).actionType(actionType).build();
    }

    private boolean existClickId(String positionId, String clickId) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            Boolean existClickId = jedis.exists(RedisKeyGenerator.strFeedbackClickId((String)positionId, (String)clickId).generateKey());
            if (existClickId.booleanValue()) {
                log.info("Plus Control the clickId has been feedback. {}", (Object)clickId);
            }
            boolean bl = existClickId;
            return bl;
        }
    }

    private JedisPool getJedisPool() {
        return this.jedisPool;
    }
}

