/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.hosting;

import com.bxm.adscounter.rtb.common.control.hosting.HostingResult;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.data.DorisAdGroupHourlyData;
import com.bxm.adsprod.facade.ticket.rtb.HostingConfig;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataContext {
    private static final Logger log = LoggerFactory.getLogger(DataContext.class);
    private String positionId;
    private Map<String, AdGroupData> rtbGroupHourDataMap;
    private List<AdGroupData> rtbGroupHourData;
    private List<AdGroupData> rtbGroupTodayData;
    private Map<String, Long> bxmGroupConvMap;
    private Map<String, BigDecimal> bxmGroupIncomeMap;
    private List<DorisAdGroupHourlyData> bxmGroupTodayIncomeList;
    private List<HostingConfig> hostingConfigs;
    private List<HostingResult> hostingResults;
    private List<String> accountAdGroupIds;
    private String schedulerTime = Objects.toString(System.currentTimeMillis());

    public BigDecimal getRtbCharge(HostingConfig config) {
        if (config.isAccount()) {
            return this.rtbGroupHourData.stream().filter(data -> this.accountAdGroupIds.contains(data.getAdGroupId())).map(AdGroupData::getCharge).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return Optional.ofNullable(this.rtbGroupHourDataMap.get(config.getDimension())).map(AdGroupData::getCharge).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getRtbTodayCharge(HostingConfig config) {
        if (config.isAccount()) {
            return this.rtbGroupTodayData.stream().filter(data -> this.accountAdGroupIds.contains(data.getAdGroupId())).map(AdGroupData::getCharge).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return this.rtbGroupTodayData.stream().filter(data -> Objects.equals(data.getAdGroupId(), config.getDimension())).map(AdGroupData::getCharge).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public BigDecimal getBxmIncome(HostingConfig config) {
        if (config.isAccount()) {
            return this.bxmGroupIncomeMap.entrySet().stream().filter(entry -> this.accountAdGroupIds.contains(entry.getKey())).map(Map.Entry::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return this.bxmGroupIncomeMap.getOrDefault(config.getDimension(), BigDecimal.ZERO);
    }

    public BigDecimal getBxmTodayIncome(HostingConfig config) {
        if (config.isAccount()) {
            return this.getBxmGroupTodayIncomeList().stream().filter(d -> this.accountAdGroupIds.contains(d.getAdGroupId())).map(DorisAdGroupHourlyData::getIncome).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        return this.getBxmGroupTodayIncomeList().stream().filter(d -> Objects.equals(d.getAdGroupId(), config.getDimension())).map(DorisAdGroupHourlyData::getIncome).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public Long getConvNum(HostingConfig config) {
        if (config.isAccount()) {
            return this.bxmGroupConvMap.entrySet().stream().filter(entry -> this.accountAdGroupIds.contains(entry.getKey())).map(Map.Entry::getValue).reduce(Long::sum).orElse(0L);
        }
        AdGroupData data = this.rtbGroupHourDataMap.get(config.getDimension());
        return Optional.ofNullable(data).map(AdGroupData::getConvNumByImpression).orElse(0L);
    }

    public BigDecimal getBillCost(HostingConfig config) throws ArithmeticException {
        return this.getRtbCharge(config).divide(BigDecimal.valueOf(this.getConvNum(config)), 2, RoundingMode.HALF_UP);
    }

    public BigDecimal getBillCostQuietly(HostingConfig config) {
        try {
            return this.getBillCost(config);
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    public BigDecimal getRoi(HostingConfig config) throws ArithmeticException {
        BigDecimal income = this.getBxmTodayIncome(config);
        BigDecimal charge = this.getRtbTodayCharge(config);
        BigDecimal roi = income.divide(charge, 2, RoundingMode.HALF_UP);
        log.info("[{}-{}] roi={}/{}", new Object[]{this.positionId, config.getDimension(), income, charge});
        return roi;
    }

    public BigDecimal getRoiQuietly(HostingConfig config) {
        try {
            return this.getRoi(config);
        }
        catch (ArithmeticException e) {
            return null;
        }
    }

    public Integer getPlusNum(HostingConfig config) throws ArithmeticException {
        return this.getRtbCharge(config).divide(config.getMaxCpa(), 2, RoundingMode.HALF_UP).subtract(BigDecimal.valueOf(this.getConvNum(config))).intValue();
    }

    public boolean isBreaker(HostingConfig config) throws ArithmeticException {
        return this.getBxmIncome(config).divide(this.getRtbCharge(config), 2, RoundingMode.HALF_UP).doubleValue() > 3.0;
    }

    public String getPositionId() {
        return this.positionId;
    }

    public Map<String, AdGroupData> getRtbGroupHourDataMap() {
        return this.rtbGroupHourDataMap;
    }

    public List<AdGroupData> getRtbGroupHourData() {
        return this.rtbGroupHourData;
    }

    public List<AdGroupData> getRtbGroupTodayData() {
        return this.rtbGroupTodayData;
    }

    public Map<String, Long> getBxmGroupConvMap() {
        return this.bxmGroupConvMap;
    }

    public Map<String, BigDecimal> getBxmGroupIncomeMap() {
        return this.bxmGroupIncomeMap;
    }

    public List<DorisAdGroupHourlyData> getBxmGroupTodayIncomeList() {
        return this.bxmGroupTodayIncomeList;
    }

    public List<HostingConfig> getHostingConfigs() {
        return this.hostingConfigs;
    }

    public List<HostingResult> getHostingResults() {
        return this.hostingResults;
    }

    public List<String> getAccountAdGroupIds() {
        return this.accountAdGroupIds;
    }

    public String getSchedulerTime() {
        return this.schedulerTime;
    }

    public DataContext setPositionId(String positionId) {
        this.positionId = positionId;
        return this;
    }

    public DataContext setRtbGroupHourDataMap(Map<String, AdGroupData> rtbGroupHourDataMap) {
        this.rtbGroupHourDataMap = rtbGroupHourDataMap;
        return this;
    }

    public DataContext setRtbGroupHourData(List<AdGroupData> rtbGroupHourData) {
        this.rtbGroupHourData = rtbGroupHourData;
        return this;
    }

    public DataContext setRtbGroupTodayData(List<AdGroupData> rtbGroupTodayData) {
        this.rtbGroupTodayData = rtbGroupTodayData;
        return this;
    }

    public DataContext setBxmGroupConvMap(Map<String, Long> bxmGroupConvMap) {
        this.bxmGroupConvMap = bxmGroupConvMap;
        return this;
    }

    public DataContext setBxmGroupIncomeMap(Map<String, BigDecimal> bxmGroupIncomeMap) {
        this.bxmGroupIncomeMap = bxmGroupIncomeMap;
        return this;
    }

    public DataContext setBxmGroupTodayIncomeList(List<DorisAdGroupHourlyData> bxmGroupTodayIncomeList) {
        this.bxmGroupTodayIncomeList = bxmGroupTodayIncomeList;
        return this;
    }

    public DataContext setHostingConfigs(List<HostingConfig> hostingConfigs) {
        this.hostingConfigs = hostingConfigs;
        return this;
    }

    public DataContext setHostingResults(List<HostingResult> hostingResults) {
        this.hostingResults = hostingResults;
        return this;
    }

    public DataContext setAccountAdGroupIds(List<String> accountAdGroupIds) {
        this.accountAdGroupIds = accountAdGroupIds;
        return this;
    }

    public DataContext setSchedulerTime(String schedulerTime) {
        this.schedulerTime = schedulerTime;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataContext)) {
            return false;
        }
        DataContext other = (DataContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$positionId = this.getPositionId();
        String other$positionId = other.getPositionId();
        if (this$positionId == null ? other$positionId != null : !this$positionId.equals(other$positionId)) {
            return false;
        }
        Map<String, AdGroupData> this$rtbGroupHourDataMap = this.getRtbGroupHourDataMap();
        Map<String, AdGroupData> other$rtbGroupHourDataMap = other.getRtbGroupHourDataMap();
        if (this$rtbGroupHourDataMap == null ? other$rtbGroupHourDataMap != null : !((Object)this$rtbGroupHourDataMap).equals(other$rtbGroupHourDataMap)) {
            return false;
        }
        List<AdGroupData> this$rtbGroupHourData = this.getRtbGroupHourData();
        List<AdGroupData> other$rtbGroupHourData = other.getRtbGroupHourData();
        if (this$rtbGroupHourData == null ? other$rtbGroupHourData != null : !((Object)this$rtbGroupHourData).equals(other$rtbGroupHourData)) {
            return false;
        }
        List<AdGroupData> this$rtbGroupTodayData = this.getRtbGroupTodayData();
        List<AdGroupData> other$rtbGroupTodayData = other.getRtbGroupTodayData();
        if (this$rtbGroupTodayData == null ? other$rtbGroupTodayData != null : !((Object)this$rtbGroupTodayData).equals(other$rtbGroupTodayData)) {
            return false;
        }
        Map<String, Long> this$bxmGroupConvMap = this.getBxmGroupConvMap();
        Map<String, Long> other$bxmGroupConvMap = other.getBxmGroupConvMap();
        if (this$bxmGroupConvMap == null ? other$bxmGroupConvMap != null : !((Object)this$bxmGroupConvMap).equals(other$bxmGroupConvMap)) {
            return false;
        }
        Map<String, BigDecimal> this$bxmGroupIncomeMap = this.getBxmGroupIncomeMap();
        Map<String, BigDecimal> other$bxmGroupIncomeMap = other.getBxmGroupIncomeMap();
        if (this$bxmGroupIncomeMap == null ? other$bxmGroupIncomeMap != null : !((Object)this$bxmGroupIncomeMap).equals(other$bxmGroupIncomeMap)) {
            return false;
        }
        List<DorisAdGroupHourlyData> this$bxmGroupTodayIncomeList = this.getBxmGroupTodayIncomeList();
        List<DorisAdGroupHourlyData> other$bxmGroupTodayIncomeList = other.getBxmGroupTodayIncomeList();
        if (this$bxmGroupTodayIncomeList == null ? other$bxmGroupTodayIncomeList != null : !((Object)this$bxmGroupTodayIncomeList).equals(other$bxmGroupTodayIncomeList)) {
            return false;
        }
        List<HostingConfig> this$hostingConfigs = this.getHostingConfigs();
        List<HostingConfig> other$hostingConfigs = other.getHostingConfigs();
        if (this$hostingConfigs == null ? other$hostingConfigs != null : !((Object)this$hostingConfigs).equals(other$hostingConfigs)) {
            return false;
        }
        List<HostingResult> this$hostingResults = this.getHostingResults();
        List<HostingResult> other$hostingResults = other.getHostingResults();
        if (this$hostingResults == null ? other$hostingResults != null : !((Object)this$hostingResults).equals(other$hostingResults)) {
            return false;
        }
        List<String> this$accountAdGroupIds = this.getAccountAdGroupIds();
        List<String> other$accountAdGroupIds = other.getAccountAdGroupIds();
        if (this$accountAdGroupIds == null ? other$accountAdGroupIds != null : !((Object)this$accountAdGroupIds).equals(other$accountAdGroupIds)) {
            return false;
        }
        String this$schedulerTime = this.getSchedulerTime();
        String other$schedulerTime = other.getSchedulerTime();
        return !(this$schedulerTime == null ? other$schedulerTime != null : !this$schedulerTime.equals(other$schedulerTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $positionId = this.getPositionId();
        result = result * 59 + ($positionId == null ? 43 : $positionId.hashCode());
        Map<String, AdGroupData> $rtbGroupHourDataMap = this.getRtbGroupHourDataMap();
        result = result * 59 + ($rtbGroupHourDataMap == null ? 43 : ((Object)$rtbGroupHourDataMap).hashCode());
        List<AdGroupData> $rtbGroupHourData = this.getRtbGroupHourData();
        result = result * 59 + ($rtbGroupHourData == null ? 43 : ((Object)$rtbGroupHourData).hashCode());
        List<AdGroupData> $rtbGroupTodayData = this.getRtbGroupTodayData();
        result = result * 59 + ($rtbGroupTodayData == null ? 43 : ((Object)$rtbGroupTodayData).hashCode());
        Map<String, Long> $bxmGroupConvMap = this.getBxmGroupConvMap();
        result = result * 59 + ($bxmGroupConvMap == null ? 43 : ((Object)$bxmGroupConvMap).hashCode());
        Map<String, BigDecimal> $bxmGroupIncomeMap = this.getBxmGroupIncomeMap();
        result = result * 59 + ($bxmGroupIncomeMap == null ? 43 : ((Object)$bxmGroupIncomeMap).hashCode());
        List<DorisAdGroupHourlyData> $bxmGroupTodayIncomeList = this.getBxmGroupTodayIncomeList();
        result = result * 59 + ($bxmGroupTodayIncomeList == null ? 43 : ((Object)$bxmGroupTodayIncomeList).hashCode());
        List<HostingConfig> $hostingConfigs = this.getHostingConfigs();
        result = result * 59 + ($hostingConfigs == null ? 43 : ((Object)$hostingConfigs).hashCode());
        List<HostingResult> $hostingResults = this.getHostingResults();
        result = result * 59 + ($hostingResults == null ? 43 : ((Object)$hostingResults).hashCode());
        List<String> $accountAdGroupIds = this.getAccountAdGroupIds();
        result = result * 59 + ($accountAdGroupIds == null ? 43 : ((Object)$accountAdGroupIds).hashCode());
        String $schedulerTime = this.getSchedulerTime();
        result = result * 59 + ($schedulerTime == null ? 43 : $schedulerTime.hashCode());
        return result;
    }

    public String toString() {
        return "DataContext(positionId=" + this.getPositionId() + ", rtbGroupHourDataMap=" + this.getRtbGroupHourDataMap() + ", rtbGroupHourData=" + this.getRtbGroupHourData() + ", rtbGroupTodayData=" + this.getRtbGroupTodayData() + ", bxmGroupConvMap=" + this.getBxmGroupConvMap() + ", bxmGroupIncomeMap=" + this.getBxmGroupIncomeMap() + ", bxmGroupTodayIncomeList=" + this.getBxmGroupTodayIncomeList() + ", hostingConfigs=" + this.getHostingConfigs() + ", hostingResults=" + this.getHostingResults() + ", accountAdGroupIds=" + this.getAccountAdGroupIds() + ", schedulerTime=" + this.getSchedulerTime() + ")";
    }
}

