/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.hosting;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.rtb.common.Rtb;
import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationFactory;
import com.bxm.adscounter.rtb.common.RtbRedisKeys;
import com.bxm.adscounter.rtb.common.control.cpa.CpaControl;
import com.bxm.adscounter.rtb.common.control.hosting.ConfigData;
import com.bxm.adscounter.rtb.common.control.hosting.DataContext;
import com.bxm.adscounter.rtb.common.control.hosting.HostingResult;
import com.bxm.adscounter.rtb.common.control.hosting.event.HostingPlusEvent;
import com.bxm.adscounter.rtb.common.control.hosting.helper.DataHelper;
import com.bxm.adscounter.rtb.common.control.hosting.helper.DataHelperFactory;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.service.PositionRtbService;
import com.bxm.adsprod.facade.ticket.rtb.HostingConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.support.CronSequenceGenerator;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class HostingScheduler {
    private static final Logger log = LoggerFactory.getLogger(HostingScheduler.class);
    private final PositionRtbService positionRtbService;
    private final CpaControl cpaControl;
    private final RtbIntegrationFactory rtbIntegrationFactory;
    private final Updater updater;
    private final Fetcher fetcher;
    private final JedisPool jedisPool;
    private final DataHelperFactory dataHelperFactory;
    private final EventPark eventPark;
    private static final int ONE_DAY_SECONDS = Math.toIntExact(Duration.ofDays(1L).getSeconds());
    private static final String cron = "0 10,20,30,40,50,55 * * * ? ";

    public HostingScheduler(PositionRtbService positionRtbService, CpaControl cpaControl, RtbIntegrationFactory rtbIntegrationFactory, Updater updater, Fetcher fetcher, DataHelperFactory dataHelperFactory, JedisPool jedisPool, EventPark eventPark) {
        this.positionRtbService = positionRtbService;
        this.cpaControl = cpaControl;
        this.rtbIntegrationFactory = rtbIntegrationFactory;
        this.updater = updater;
        this.fetcher = fetcher;
        this.jedisPool = jedisPool;
        this.dataHelperFactory = dataHelperFactory;
        this.eventPark = eventPark;
    }

    @Scheduled(cron="0 10,20,30,40,50,55 * * * ? ")
    public void execute() {
        long start = System.currentTimeMillis();
        List<PositionRtb> positionRtbs = this.positionRtbService.getAll();
        for (PositionRtb positionRtb : positionRtbs) {
            try {
                this.executePosition(positionRtb);
            }
            catch (Exception e) {
                log.error("Hosting Scheduler Error", (Throwable)e);
            }
        }
        log.info("hosting scheduler finished in {}ms", (Object)(System.currentTimeMillis() - start));
    }

    public void executePosition(PositionRtb positionRtb) {
        if (!positionRtb.isEnableSmartHosting()) {
            return;
        }
        DataHelper dataHelper = (DataHelper)this.dataHelperFactory.get(positionRtb.getSourceType());
        if (dataHelper == null) {
            return;
        }
        List hostingConfigs = JSONObject.parseArray((String)positionRtb.getHostingConfig(), HostingConfig.class);
        if (CollectionUtils.isEmpty((Collection)hostingConfigs)) {
            return;
        }
        DataContext dataContext = dataHelper.buildDataContext(positionRtb, hostingConfigs);
        for (HostingConfig config : hostingConfigs) {
            try {
                ConfigData configData = this.createConfigData(positionRtb, config, dataContext);
                if (this.doIntercept(configData)) {
                    this.resetMode(configData.getPositionId(), config.getDimension(), configData.getAccountAdGroupIds(), "\u62e6\u622a\u5668\u62e6\u622a");
                    continue;
                }
                this.processByMode(configData);
            }
            catch (ArithmeticException e) {
                this.resetMode(positionRtb.getPositionId(), config.getDimension(), dataContext.getAccountAdGroupIds(), "\u8ba1\u7b97\u4e2d\u5206\u6bcd\u4e3a0");
            }
        }
        this.save(dataContext, hostingConfigs);
    }

    private void processByMode(ConfigData configData) {
        Integer summaryCpaMode = this.chooseSummaryCpaMode(configData);
        switch (summaryCpaMode) {
            case 1: {
                this.updateMode(configData.getPositionId(), configData.getDimension(), 1);
                break;
            }
            case 2: {
                this.handleModeFeedbackOnly(configData);
                break;
            }
            default: {
                this.resetMode(configData.getPositionId(), configData.getDimension(), configData.getAccountAdGroupIds(), "cpa\u533a\u95f4\u5224\u65ad");
            }
        }
    }

    private void handleModeFeedbackOnly(ConfigData configData) {
        String positionId = configData.getPositionId();
        if (configData.getRoi().compareTo(configData.getExpectRoi()) <= 0) {
            log.info("[{}-{}]roi({})\u5c0f\u4e8e\u7b49\u4e8e\u76ee\u6807roi({}),\u4e0d\u6267\u884c\u8865\u91cf", new Object[]{positionId, configData.getDimension(), configData.getRoi(), configData.getExpectRoi()});
            return;
        }
        Integer plusNum = configData.getPlusNum();
        if (plusNum > 0) {
            List<String> adGroupIds = this.getAdGroupIds(configData);
            List<FeedbackRequest> feedbackRequests = this.cpaControl.getOnConversionQueue(positionId, adGroupIds, plusNum);
            int remain = plusNum - feedbackRequests.size();
            log.info("[{}-{}]\u672c\u6b21\u8865\u91cf{} / {}", new Object[]{positionId, configData.getDimension(), feedbackRequests.size(), plusNum});
            if (remain > 0) {
                this.switchAlgAndUpdate(remain, adGroupIds, configData);
            } else {
                this.resetMode(positionId, configData.getDimension(), configData.getAccountAdGroupIds(), "\u5df2\u6ee1\u8db3\u8865\u91cf\u6570");
            }
            RtbIntegration integration = this.rtbIntegrationFactory.get(Rtb.of(configData.getSourceType()));
            this.eventPark.post((EventObject)new HostingPlusEvent(this, feedbackRequests, integration, positionId, configData.getDimension()));
        } else {
            this.resetMode(positionId, configData.getDimension(), configData.getAccountAdGroupIds(), "\u8ba1\u7b97\u51fa\u8865\u91cf\u6570\u4e3a0\uff0c\u65e0\u9700\u8865\u91cf");
        }
    }

    private boolean doIntercept(ConfigData configData) {
        if (configData.getIsBreaker().booleanValue()) {
            log.info("[{}-{}]\u672c\u6b21\u7194\u65ad\uff01", (Object)configData.getPositionId(), (Object)configData.getDimension());
            return true;
        }
        boolean convNotUpdated = this.checkConvNotUpdated(configData);
        if (convNotUpdated) {
            log.info("[{}-{}]\u672c\u6b21\u8f6c\u5316\u6570\u672a\u66f4\u65b0\uff01", (Object)configData.getPositionId(), (Object)configData.getDimension());
        }
        return convNotUpdated;
    }

    private void switchAlgAndUpdate(int remain, List<String> adGroupIds, ConfigData configData) {
        String positionId = configData.getPositionId();
        String dimension = configData.getDimension();
        for (String fetchAdGroupId : adGroupIds) {
            this.updater.update(RtbRedisKeys.strAlgSmartHostingSwitch(positionId, fetchAdGroupId), (Object)1, Math.toIntExact(Duration.ofMinutes(15L).getSeconds()));
        }
        this.updateMode(positionId, dimension, 2);
        this.updater.update(RtbRedisKeys.strHostingRemainPlusNum(positionId, dimension), (Object)remain, this.getNextScheduleSecond().intValue());
    }

    private ConfigData createConfigData(PositionRtb positionRtb, HostingConfig config, DataContext dataContext) {
        return new ConfigData().setPositionId(positionRtb.getPositionId()).setDimension(config.getDimension()).setExpectRoi(config.getExpectRoi()).setIncome(dataContext.getBxmIncome(config)).setCharge(dataContext.getRtbCharge(config)).setBillCost(dataContext.getBillCost(config)).setRoi(dataContext.getRoi(config)).setMinCpa(config.getMinCpa()).setMaxCpa(config.getMaxCpa()).setPlusNum(dataContext.getPlusNum(config)).setIsBreaker(dataContext.isBreaker(config)).setSchedulerTime(dataContext.getSchedulerTime()).setAccountAdGroupIds(dataContext.getAccountAdGroupIds()).setSourceType(positionRtb.getSourceType());
    }

    private Integer chooseSummaryCpaMode(ConfigData configData) {
        BigDecimal billCost = configData.getBillCost();
        if (billCost.compareTo(configData.getMinCpa()) < 0) {
            return 1;
        }
        if (billCost.compareTo(configData.getMaxCpa()) > 0) {
            return 2;
        }
        return 0;
    }

    private boolean checkConvNotUpdated(ConfigData configData) {
        String positionId = configData.getPositionId();
        String dimension = configData.getDimension();
        Long thisConvNum = Optional.ofNullable(configData.getConvNum()).orElse(0L);
        String fetchValue = (String)this.fetcher.fetch(RtbRedisKeys.strRtbApiConvNum(positionId, dimension), String.class);
        this.updater.update(RtbRedisKeys.strRtbApiConvNum(positionId, dimension), (Object)(System.currentTimeMillis() + "|" + thisConvNum), ONE_DAY_SECONDS);
        if (StringUtils.isBlank((String)fetchValue)) {
            return false;
        }
        String[] split = StringUtils.split((String)fetchValue, (String)"|");
        String lastScheduleTime = split[0];
        Long lastConvNum = Optional.ofNullable(split[1]).map(Long::valueOf).orElse(0L);
        String thisScheduleTime = configData.getSchedulerTime();
        log.info("[{}-{}] lastConvNum:{} thisConvNum:{}  lastScheduleTime:{} scheduleTime:{} ", new Object[]{positionId, dimension, lastConvNum, thisConvNum, lastScheduleTime, thisScheduleTime});
        if (!Objects.equals(lastConvNum, thisConvNum)) {
            return false;
        }
        if (configData.isAccount()) {
            return this.checkAccountConvNotUpdated(configData, positionId, lastScheduleTime, thisScheduleTime);
        }
        Long zcount = this.zcount(RtbRedisKeys.strAdGroupConv(positionId, dimension).generateKey(), lastScheduleTime, thisScheduleTime);
        if (zcount > 0L) {
            log.info("[{}-{}] zcount>0", (Object)positionId, (Object)dimension);
        }
        this.zrem(RtbRedisKeys.strAdGroupConv(positionId, dimension).generateKey(), lastScheduleTime, thisScheduleTime);
        return zcount > 0L;
    }

    private boolean checkAccountConvNotUpdated(ConfigData configData, String positionId, String lastTimestamp, String schedulerTime) {
        List<String> accountAdGroupIds = configData.getAccountAdGroupIds();
        if (CollectionUtils.isNotEmpty(accountAdGroupIds)) {
            for (String adGroupId : accountAdGroupIds) {
                Long zcount = this.zcount(RtbRedisKeys.strAdGroupConv(positionId, adGroupId).generateKey(), lastTimestamp, schedulerTime);
                if (zcount <= 0L) continue;
                log.info("[{}-{}] zcount>0", (Object)positionId, (Object)"ACCOUNT");
                return true;
            }
            for (String adGroupId : accountAdGroupIds) {
                this.zrem(RtbRedisKeys.strAdGroupConv(positionId, adGroupId).generateKey(), lastTimestamp, schedulerTime);
            }
        }
        return false;
    }

    private void save(DataContext dataContext, List<HostingConfig> hostingConfigs) {
        String positionId = dataContext.getPositionId();
        for (HostingConfig config : hostingConfigs) {
            ArrayList adGroupIds = config.isAccount() ? dataContext.getAccountAdGroupIds() : Lists.newArrayList((Object[])new String[]{config.getDimension()});
            long queueSize = this.cpaControl.getQueueSize(positionId, adGroupIds);
            HostingResult hostingResult = new HostingResult().setDimension(config.getDimension()).setCharge(dataContext.getRtbCharge(config)).setIncome(dataContext.getBxmIncome(config)).setConvNum(dataContext.getConvNum(config)).setBillCost(dataContext.getBillCostQuietly(config)).setRoi(dataContext.getRoiQuietly(config)).setPreparePlusNum(queueSize).setAccountAdGroupIds(dataContext.getAccountAdGroupIds());
            this.updater.update(RtbRedisKeys.strHostingData(positionId, config.getDimension()), (Object)hostingResult, ONE_DAY_SECONDS);
            log.info("[{}-{}]Save hosting data finished! {}", new Object[]{positionId, config.getDimension(), hostingResult});
        }
    }

    private List<String> getAdGroupIds(ConfigData configData) {
        return configData.isAccount() ? configData.getAccountAdGroupIds() : Lists.newArrayList((Object[])new String[]{configData.getDimension()});
    }

    private Integer getNextScheduleSecond() {
        try {
            CronSequenceGenerator generator = new CronSequenceGenerator(cron);
            Date nextScheduleTime = generator.next(new Date());
            return (int)Math.abs(nextScheduleTime.getTime() - System.currentTimeMillis()) / 1000;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 300;
        }
    }

    private void updateMode(String positionId, String dimension, Integer mode) {
        this.updater.update(RtbRedisKeys.strAdGroupSummaryCpaMode(positionId, dimension), (Object)mode, Math.toIntExact(Duration.ofMinutes(15L).getSeconds()));
        log.info("[{}-{}]\u7d2f\u52a0\u66f4\u65b0\u72b6\u6001\u4e3a{}", new Object[]{positionId, dimension, mode});
    }

    public void resetMode(String positionId, String dimension, List<String> accountAdGroupIds, String reason) {
        this.updater.remove(RtbRedisKeys.strAdGroupSummaryCpaMode(positionId, dimension));
        ArrayList adGroupIds = Objects.equals(dimension, "ACCOUNT") ? accountAdGroupIds : Lists.newArrayList((Object[])new String[]{dimension});
        for (String adGroupId : adGroupIds) {
            this.updater.remove(RtbRedisKeys.strAlgSmartHostingSwitch(positionId, adGroupId));
        }
        log.info("[{}-{}]\u7d2f\u52a0\u5df2\u5207\u6362\u9ed8\u8ba4\u72b6\u6001\uff08\u539f\u56e0\uff1a{}\uff09", new Object[]{positionId, dimension, reason});
    }

    public Long zcount(String key, String startTime, String endTime) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            Long l = Optional.ofNullable(jedis.zcount(key, startTime, endTime)).orElse(0L);
            return l;
        }
    }

    public void zrem(String key, String startTime, String endTime) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.zremrangeByScore(key, startTime, endTime);
        }
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }
}

