/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.hosting.helper;

import com.alibaba.fastjson.JSON;
import com.bxm.adscounter.rtb.common.DataFetchFailException;
import com.bxm.adscounter.rtb.common.DataFetcher;
import com.bxm.adscounter.rtb.common.control.hosting.DataContext;
import com.bxm.adscounter.rtb.common.control.hosting.helper.DataHelper;
import com.bxm.adscounter.rtb.common.data.AdGroupData;
import com.bxm.adscounter.rtb.common.data.DorisAdGroupConversionData;
import com.bxm.adscounter.rtb.common.data.DorisAdGroupHourlyData;
import com.bxm.adscounter.rtb.common.data.Parameter;
import com.bxm.adscounter.rtb.common.mapper.DorisMapper;
import com.bxm.adsprod.facade.ticket.rtb.HostingConfig;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.utils.DateHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataHelper
implements DataHelper {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataHelper.class);
    private final DorisMapper dorisMapper;

    protected AbstractDataHelper(DorisMapper dorisMapper) {
        this.dorisMapper = dorisMapper;
    }

    protected abstract DataFetcher getDataFetcher();

    @Override
    public DataContext buildDataContext(PositionRtb positionRtb, List<HostingConfig> hostingConfigs) {
        List<AdGroupData> rtbGroupTodayData = this.getRtbGroupTodayData(positionRtb);
        String hour = AbstractDataHelper.getHour();
        List<AdGroupData> rtbGroupHourData = rtbGroupTodayData.stream().filter(data -> Objects.equals(Objects.toString(data.getHour()), hour)).collect(Collectors.toList());
        Map<String, AdGroupData> rtbGorupHourDataMap = rtbGroupHourData.stream().filter(data -> StringUtils.isNotBlank((String)data.getAdGroupId())).collect(Collectors.toMap(AdGroupData::getAdGroupId, d -> d));
        return new DataContext().setPositionId(positionRtb.getPositionId()).setHostingConfigs(hostingConfigs).setRtbGroupHourData(rtbGroupHourData).setRtbGroupHourDataMap(rtbGorupHourDataMap).setRtbGroupTodayData(rtbGroupTodayData).setBxmGroupConvMap(this.getBxmGroupConvMap(positionRtb)).setBxmGroupIncomeMap(this.getBxmGroupIncomeMap(positionRtb)).setBxmGroupTodayIncomeList(this.getBxmGroupTodayIncomeList(positionRtb)).setAccountAdGroupIds(this.getAccountAdGroupIds(rtbGroupTodayData, hostingConfigs));
    }

    protected List<AdGroupData> getRtbGroupTodayData(PositionRtb positionRtb) {
        try {
            Parameter parameter = Parameter.builder().tagId(positionRtb.getPositionId()).build();
            List<AdGroupData> adGroupHourDataList = this.getDataFetcher().fetchTodayData(parameter);
            if (Objects.isNull(adGroupHourDataList)) {
                throw new DataFetchFailException(String.format("[%s] fetch data is null. positionId: %s", new Object[]{this.rtb(), positionRtb.getPositionId()}));
            }
            log.info("fetch size {} - {}", (Object)adGroupHourDataList.size(), (Object)JSON.toJSONString(adGroupHourDataList));
            return adGroupHourDataList;
        }
        catch (DataFetchFailException e) {
            log.warn("today data fetch fail : {}", (Object)e.getMessage());
            return Lists.newArrayList();
        }
    }

    protected Map<String, Long> getBxmGroupConvMap(PositionRtb positionRtb) {
        List<DorisAdGroupConversionData> adGroupConversionData = this.dorisMapper.getAdGroupConversionData(positionRtb.getPositionId(), null, DateHelper.format((String)"yyyyMMdd"), AbstractDataHelper.getHour(), this.rtb().getType());
        return adGroupConversionData.stream().collect(Collectors.toMap(data -> data.getAdGroupId(), data -> data.getSendValidPv()));
    }

    protected Map<String, BigDecimal> getBxmGroupIncomeMap(PositionRtb positionRtb) {
        List<DorisAdGroupHourlyData> adGroupHourlyData = this.dorisMapper.getAdGroupHourlyData(positionRtb.getPositionId(), null, DateHelper.format((String)"yyyy-MM-dd"), DateHelper.format((String)"HH"));
        return adGroupHourlyData.stream().collect(Collectors.toMap(data -> data.getAdGroupId(), data -> data.getIncome()));
    }

    protected List<DorisAdGroupHourlyData> getBxmGroupTodayIncomeList(PositionRtb positionRtb) {
        List<DorisAdGroupHourlyData> adGroupTodayData = this.dorisMapper.getAdGroupHourlyData(positionRtb.getPositionId(), null, DateHelper.format((String)"yyyy-MM-dd"), null);
        return adGroupTodayData;
    }

    private List<String> getAccountAdGroupIds(List<AdGroupData> rtbGroupData, List<HostingConfig> hostingConfigs) {
        List<String> accountAdGroupIds = rtbGroupData.stream().map(AdGroupData::getAdGroupId).collect(Collectors.toList());
        accountAdGroupIds.removeAll(hostingConfigs.stream().map(HostingConfig::getDimension).collect(Collectors.toList()));
        accountAdGroupIds.add("0");
        accountAdGroupIds.add("ACCOUNT");
        return accountAdGroupIds;
    }

    private static String getHour() {
        return DateHelper.format((String)"HH");
    }
}

