/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.hosting.listener;

import com.bxm.adscounter.rtb.common.RtbIntegration;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.RtbRedisKeys;
import com.bxm.adscounter.rtb.common.control.hosting.event.HostingPlusEvent;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.feedback.SmartConvType;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.time.Duration;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostingPlusEventListener
implements EventListener<HostingPlusEvent> {
    private static final Logger log = LoggerFactory.getLogger(HostingPlusEventListener.class);
    private static final int EXPIRE_TIME = Math.toIntExact(Duration.ofDays(1L).getSeconds());
    private final Counter counter;

    public HostingPlusEventListener(Counter counter) {
        this.counter = counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @AllowConcurrentEvents
    public void consume(HostingPlusEvent event) {
        List<FeedbackRequest> feedbackRequests = event.getFeedbackRequests();
        if (CollectionUtils.isNotEmpty(feedbackRequests)) {
            RtbIntegration integration = event.getIntegration();
            for (FeedbackRequest feedbackRequest : feedbackRequests) {
                try {
                    feedbackRequest.setSmartConvType(SmartConvType.CONV_QUEUE);
                    integration.doFeedback(feedbackRequest, 1);
                    log.info("[{}-{}]\u667a\u80fd\u6258\u7ba1\u8865\u91cf\u5df2\u56de\u4f20", (Object)event.getPositionId(), (Object)feedbackRequest.getAdGroupId());
                }
                catch (RtbIntegrationException e) {
                    log.error("RTB smart hosting. plus feedback occur exception", (Throwable)e);
                }
                finally {
                    this.counter.hincrementAndGet(RtbRedisKeys.hashHostingPlusFinishNum(event.getPositionId()), event.getDimension(), EXPIRE_TIME);
                }
            }
        }
    }
}

