/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.plus;

import com.bxm.adscounter.rtb.common.feedback.ActionType;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Consumer;

public class PlusControlConfig {
    private String dimension;
    private Integer controlId;
    private String date;
    private String startTime;
    private String endTime;
    private int limit;
    private Integer n;
    private Integer y;
    private Consumer<FeedbackRequest> consumer;
    private String positionId;
    private String adGroupId;
    private PositionRtb positionRtb;
    private ActionType actionType;
    private String adId;

    public boolean isUpdate(long limit) {
        return (long)this.getLimit() != limit;
    }

    public String toSimpleString() {
        return "PlusControlConfig{date=" + this.date + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", limit=" + this.limit + '}';
    }

    public boolean notInTime(Long timestamp) {
        LocalDateTime startLocalDate = LocalDateTime.parse(this.startTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endLocalDate = LocalDateTime.parse(this.endTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime createDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        return createDateTime.isBefore(startLocalDate) || createDateTime.isAfter(endLocalDate);
    }

    public boolean isEveryGroupDimension() {
        return Objects.equals(this.adGroupId, "");
    }

    public boolean isTotalDimension() {
        return Objects.equals(this.adGroupId, "0");
    }

    public String getDimension() {
        return this.dimension;
    }

    public Integer getControlId() {
        return this.controlId;
    }

    public String getDate() {
        return this.date;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public int getLimit() {
        return this.limit;
    }

    public Integer getN() {
        return this.n;
    }

    public Integer getY() {
        return this.y;
    }

    public Consumer<FeedbackRequest> getConsumer() {
        return this.consumer;
    }

    public String getPositionId() {
        return this.positionId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public PositionRtb getPositionRtb() {
        return this.positionRtb;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public String getAdId() {
        return this.adId;
    }

    public PlusControlConfig setDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    public PlusControlConfig setControlId(Integer controlId) {
        this.controlId = controlId;
        return this;
    }

    public PlusControlConfig setDate(String date) {
        this.date = date;
        return this;
    }

    public PlusControlConfig setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public PlusControlConfig setEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public PlusControlConfig setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public PlusControlConfig setN(Integer n) {
        this.n = n;
        return this;
    }

    public PlusControlConfig setY(Integer y) {
        this.y = y;
        return this;
    }

    public PlusControlConfig setConsumer(Consumer<FeedbackRequest> consumer) {
        this.consumer = consumer;
        return this;
    }

    public PlusControlConfig setPositionId(String positionId) {
        this.positionId = positionId;
        return this;
    }

    public PlusControlConfig setAdGroupId(String adGroupId) {
        this.adGroupId = adGroupId;
        return this;
    }

    public PlusControlConfig setPositionRtb(PositionRtb positionRtb) {
        this.positionRtb = positionRtb;
        return this;
    }

    public PlusControlConfig setActionType(ActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public PlusControlConfig setAdId(String adId) {
        this.adId = adId;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlusControlConfig)) {
            return false;
        }
        PlusControlConfig other = (PlusControlConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        Integer this$controlId = this.getControlId();
        Integer other$controlId = other.getControlId();
        if (this$controlId == null ? other$controlId != null : !((Object)this$controlId).equals(other$controlId)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$y = this.getY();
        Integer other$y = other.getY();
        if (this$y == null ? other$y != null : !((Object)this$y).equals(other$y)) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        String this$startTime = this.getStartTime();
        String other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime)) {
            return false;
        }
        String this$endTime = this.getEndTime();
        String other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !this$endTime.equals(other$endTime)) {
            return false;
        }
        Consumer<FeedbackRequest> this$consumer = this.getConsumer();
        Consumer<FeedbackRequest> other$consumer = other.getConsumer();
        if (this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer)) {
            return false;
        }
        String this$positionId = this.getPositionId();
        String other$positionId = other.getPositionId();
        if (this$positionId == null ? other$positionId != null : !this$positionId.equals(other$positionId)) {
            return false;
        }
        String this$adGroupId = this.getAdGroupId();
        String other$adGroupId = other.getAdGroupId();
        if (this$adGroupId == null ? other$adGroupId != null : !this$adGroupId.equals(other$adGroupId)) {
            return false;
        }
        PositionRtb this$positionRtb = this.getPositionRtb();
        PositionRtb other$positionRtb = other.getPositionRtb();
        if (this$positionRtb == null ? other$positionRtb != null : !this$positionRtb.equals(other$positionRtb)) {
            return false;
        }
        ActionType this$actionType = this.getActionType();
        ActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        String this$adId = this.getAdId();
        String other$adId = other.getAdId();
        return !(this$adId == null ? other$adId != null : !this$adId.equals(other$adId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlusControlConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        Integer $controlId = this.getControlId();
        result = result * 59 + ($controlId == null ? 43 : ((Object)$controlId).hashCode());
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $y = this.getY();
        result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        String $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
        String $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : $endTime.hashCode());
        Consumer<FeedbackRequest> $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        String $positionId = this.getPositionId();
        result = result * 59 + ($positionId == null ? 43 : $positionId.hashCode());
        String $adGroupId = this.getAdGroupId();
        result = result * 59 + ($adGroupId == null ? 43 : $adGroupId.hashCode());
        PositionRtb $positionRtb = this.getPositionRtb();
        result = result * 59 + ($positionRtb == null ? 43 : $positionRtb.hashCode());
        ActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        String $adId = this.getAdId();
        result = result * 59 + ($adId == null ? 43 : $adId.hashCode());
        return result;
    }

    public String toString() {
        return "PlusControlConfig(dimension=" + this.getDimension() + ", controlId=" + this.getControlId() + ", date=" + this.getDate() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", limit=" + this.getLimit() + ", n=" + this.getN() + ", y=" + this.getY() + ", consumer=" + this.getConsumer() + ", positionId=" + this.getPositionId() + ", adGroupId=" + this.getAdGroupId() + ", positionRtb=" + this.getPositionRtb() + ", actionType=" + (Object)((Object)this.getActionType()) + ", adId=" + this.getAdId() + ")";
    }
}

