/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.rtb.common.control.plus;

import com.bxm.adscounter.model.constant.RedisKeyGenerator;
import com.bxm.adscounter.rtb.common.control.plus.PlusQueueService;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class PlusQueueServiceImpl
implements PlusQueueService {
    private static final Logger log = LoggerFactory.getLogger(PlusQueueServiceImpl.class);
    private static final int EXPIRE_TIME = Math.toIntExact(Duration.ofDays(7L).getSeconds());
    private static final String SPLIT = "|";
    private final JedisPool jedisPool;

    public PlusQueueServiceImpl(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public void pushConversion(FeedbackRequest feedbackRequest) {
        PositionRtb config = feedbackRequest.getConfig();
        String adGroupId = feedbackRequest.getAdGroupId();
        String positionId = config.getPositionId();
        String data = JsonHelper.convert((Object)feedbackRequest);
        String largeId = PlusQueueServiceImpl.createLargeId(data);
        if (log.isDebugEnabled()) {
            log.debug("\u5b58\u50a8\u8865\u91cf\u56de\u4f20\u6570\u636e...{} - {}", (Object)positionId, (Object)adGroupId);
        }
        String key = PlusQueueServiceImpl.listConversionQueue(positionId, adGroupId).generateKey();
        this.leftAddConversion(key, largeId);
        this.rightPopAnExpired(key);
    }

    @Override
    public List<FeedbackRequest> getOnConversionQueue(String positionId, List<String> adGroupIds, Integer size, String startTime, String endTime) {
        if (size <= 0) {
            return Collections.emptyList();
        }
        ArrayList<FeedbackRequest> results = new ArrayList<FeedbackRequest>();
        for (String adGroupId : adGroupIds) {
            String pop;
            ArrayList repushList = Lists.newArrayList();
            if (results.size() >= size) break;
            String key = PlusQueueServiceImpl.listConversionQueue(positionId, adGroupId).generateKey();
            while (!StringUtils.isBlank((String)(pop = this.rightPopWithValid(key, startTime, endTime, repushList)))) {
                FeedbackRequest feedbackRequest = (FeedbackRequest)JsonHelper.convert((String)pop, FeedbackRequest.class);
                if (!this.existClickId(positionId, feedbackRequest.getClickId())) {
                    feedbackRequest.setAdGroupId(adGroupId);
                    results.add(feedbackRequest);
                }
                if (results.size() < size) continue;
            }
            for (String item : repushList) {
                this.rightAddConversion(key, item);
            }
        }
        return results;
    }

    public void rightPopAnExpired(String key) {
        String item = this.rightPop(key);
        if (StringUtils.isBlank((String)item)) {
            return;
        }
        String[] largeId = PlusQueueServiceImpl.splitLargeId(item);
        long createTime = NumberUtils.toLong((String)largeId[0]);
        if (this.isExpireTime(createTime)) {
            log.info("[{}] Pop an expired", (Object)key);
        } else {
            this.rightAddConversion(key, item);
        }
    }

    private String rightPopWithValid(String key, String startTime, String endTime, List<String> repushList) {
        String item = this.rightPop(key);
        if (StringUtils.isBlank((String)item)) {
            return null;
        }
        String[] largeId = PlusQueueServiceImpl.splitLargeId(item);
        long createTime = NumberUtils.toLong((String)largeId[0]);
        if (this.isExpireTime(createTime)) {
            return this.rightPopWithValid(key, startTime, endTime, repushList);
        }
        if (this.isNotHitTime(createTime, startTime, endTime)) {
            repushList.add(item);
            return this.rightPopWithValid(key, startTime, endTime, repushList);
        }
        if (log.isDebugEnabled()) {
            log.debug("pop {}", (Object)item);
        }
        return largeId[1];
    }

    static KeyGenerator listConversionQueue(String positionId, String adGroupId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"rtb", "common_conv_queue", positionId, adGroupId});
    }

    private void leftAddConversion(String key, String data) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.lpush(key, new String[]{data});
            jedis.expire(key, EXPIRE_TIME);
        }
    }

    private void rightAddConversion(String key, String data) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            jedis.rpush(key, new String[]{data});
            jedis.expire(key, EXPIRE_TIME);
        }
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String rightPop(String key) {
        try (Jedis jedis = this.getJedisPool().getResource();){
            String string = jedis.rpop(key);
            return string;
        }
        catch (Exception e) {
            log.error("rpop: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static String createLargeId(String data) {
        return System.currentTimeMillis() + SPLIT + data;
    }

    static String[] splitLargeId(String id) {
        int i = id.indexOf(SPLIT);
        if (i == -1) {
            throw new IllegalStateException(String.format("%s is illegal value", id));
        }
        String t = id.substring(0, i);
        String d = id.substring(i + 1);
        return new String[]{t, d};
    }

    private boolean isNotHitTime(Long createTime, String startTime, String endTime) {
        LocalDateTime startDateTime = LocalDateTime.parse(startTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endDateTime = LocalDateTime.parse(endTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime createDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(createTime), ZoneId.systemDefault());
        return createDateTime.isBefore(startDateTime) || createDateTime.isAfter(endDateTime);
    }

    private boolean isExpireTime(Long createTime) {
        Duration duration = Duration.ofSeconds(EXPIRE_TIME);
        return System.currentTimeMillis() - createTime > duration.toMillis();
    }

    private boolean existClickId(String positionId, String clickId) {
        JedisPool jedisPool = this.getJedisPool();
        try (Jedis jedis = jedisPool.getResource();){
            Boolean existClickId = jedis.exists(RedisKeyGenerator.strFeedbackClickId((String)positionId, (String)clickId).generateKey());
            if (existClickId.booleanValue()) {
                log.info("Plus Control the clickId has been feedback. {}", (Object)clickId);
            }
            boolean bl = existClickId;
            return bl;
        }
    }
}

